<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Barta_Core;

use Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) exit;

class Info_Box extends Custom_Widget_Base {

	public function __construct( $data = [], $args = null ){
		$this->rt_name = __( 'Info Box', 'barta-core' );
		$this->rt_base = 'rt-info-box';
		parent::__construct( $data, $args );
	}

	public function rt_fields(){
		$fields = array(
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_general',
				'label'   => __( 'General', 'barta-core' ),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'style',
				'label'   => __( 'Style', 'barta-core' ),
				'options' => array(
					'style1' => __( 'Style 1', 'barta-core' ),
					'style2' => __( 'Style 2', 'barta-core' ),
					'style3' => __( 'Style 3', 'barta-core' ),
					'style4' => __( 'Style 4', 'barta-core' ),
					'style5' => __( 'Style 5', 'barta-core' ),
					'style6' => __( 'Style 6', 'barta-core' ),
					'style7' => __( 'Style 7', 'barta-core' ),
				),
				'default' => 'style1',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'icontype',
				'label'   => __( 'Icon Type', 'barta-core' ),
				'options' => array(
					'icon'  => __( 'Icon', 'barta-core' ),
					'image' => __( 'Custom Image', 'barta-core' ),
				),
				'default' => 'icon',
				'condition'   => array( 'style' => array( 'style1', 'style2', 'style5' ) ),
			),
			array(
				'type'    => Controls_Manager::ICON,
				'id'      => 'icon',
				'label'   => __( 'Icon', 'barta-core' ),
				'default' => 'fa fa-university',
				'condition'   => array( 'style' => array( 'style1', 'style2', 'style5', 'style6' ), 'icontype' => array( 'icon' ) ),
			),
			array(
				'type'    => Controls_Manager::MEDIA,
				'id'      => 'image',
				'label'   => __( 'Image', 'barta-core' ),
				'condition'   => array( 'style' => array( 'style1', 'style2' ), 'icontype' => array( 'image' ) ),
				'description' => __( 'Recommended image size is 67x67 px', 'barta-core' ),
			),
			array(
				'type'    => Controls_Manager::MEDIA,
				'id'      => 'image-alt',
				'label'   => __( 'Image', 'barta-core' ),
				'condition'   => array( 'style' => array( 'style3', 'style4', 'style7' ) ),
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'interest',
				'label'   => __( 'Interest Loan', 'barta-core' ),
				'default' => '',
				'condition'   => array( 'style' => array( 'style3', 'style4' ) ),
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'title',
				'label'   => __( 'Title', 'barta-core' ),
				'default' => 'Lorem Ipsum',
			),
			array(
				'type'    => Controls_Manager::TEXTAREA,
				'id'      => 'content',
				'label'   => __( 'Content', 'barta-core' ),
				'default' => 'Lorem Ipsum hasbeen standard daand scrambled. Rimply dummy text of the printing and typesetting industry',
			),
			array(
				'type'  => Controls_Manager::URL,
				'id'    => 'moreurl',
				'label' => __( 'More Link (Optional)', 'barta-core' ),
				'placeholder' => 'https://your-link.com',
				'condition'   => array( 'style' => array( 'style5' ) ),
			),
			array(
				'type'  => Controls_Manager::URL,
				'id'    => 'url',
				'label' => __( 'Link (Optional)', 'barta-core' ),
				'placeholder' => 'https://your-link.com',
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'buttontext',
				'label'   => __( 'Button Text', 'barta-core' ),
				'default' => 'Read More',
				'condition'   => array( 'style' => array( 'style7' ) ),
			),
			array(
				'mode' => 'section_end',
			),
		);
		return $fields;
	}

	protected function render() {
		$data = $this->get_settings();

		$template = 'info-box';

		return $this->rt_template( $template, $data );
	}
}