<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Barta_Core;

use Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) exit;

class Post_Grid extends Custom_Widget_Base {

	public function __construct( $data = [], $args = null ){
		$this->rt_name = __( 'Post Grid', 'barta-core' );
		$this->rt_base = 'rt-post-grid';
		$this->rt_translate = array(
			'cols'  => array(
				'12' => __( '1 Col', 'barta-core' ),
				'6'  => __( '2 Col', 'barta-core' ),
				'4'  => __( '3 Col', 'barta-core' ),
				'3'  => __( '4 Col', 'barta-core' ),
				'2'  => __( '6 Col', 'barta-core' ),
			),
		);
		parent::__construct( $data, $args );
	}

	private function rt_load_scripts(){
		wp_enqueue_script( 'isotope-pkgd' );
	}

	public function rt_fields(){
		$fields = array(
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_general',
				'label'   => __( 'General', 'barta-core' ),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'style',
				'label'   => __( 'Style', 'barta-core' ),
				'options' => array(
					'style1' => __( 'Style 1', 'barta-core' ),
					'style2' => __( 'Style 2', 'barta-core' ),
					'style3' => __( 'Style 3', 'barta-core' ),
				),
				'default' => 'style1',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'orderby',
				'label'   => __( 'Order By', 'barta-core' ),
				'options' => array(
					'date'        => __( 'Date (Recents comes first)', 'barta-core' ),
					'title'       => __( 'Title', 'barta-core' ),
					'menu_order'  => __( 'Custom Order (Available via Order field inside Page Attributes box)', 'barta-core' ),
				),
				'default' => 'date',
			),
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'count',
				'label'   => __( 'Word count', 'barta-core' ),
				'default' => 10,
				'description' => __( 'Maximum number of words', 'barta-core' ),
			),
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'itemlimit',
				'label'   => __( 'Item Limit', 'barta-core' ),
				'default' => 3,
				'description' => __( 'Maximum number of words', 'barta-core' ),
			),
			array(
				'mode' => 'section_end',
			),

			// Responsive Columns
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_responsive',
				'label'   => __( 'Number of Responsive Columns', 'barta-core' ),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'col_lg',
				'label'   => __( 'Desktops: > 1199px', 'barta-core' ),
				'options' => $this->rt_translate['cols'],
				'default' => '4',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'col_md',
				'label'   => __( 'Desktops: > 991px', 'barta-core' ),
				'options' => $this->rt_translate['cols'],
				'default' => '4',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'col_sm',
				'label'   => __( 'Tablets: > 767px', 'barta-core' ),
				'options' => $this->rt_translate['cols'],
				'default' => '6',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'col_xs',
				'label'   => __( 'Phones: < 768px', 'barta-core' ),
				'options' => $this->rt_translate['cols'],
				'default' => '12',
			),
			array(
				'mode' => 'section_end',
			),
		);
		return $fields;
	}

	protected function render() {
		$data = $this->get_settings();

		$this->rt_load_scripts();

		switch ( $data['style'] ) {
			case 'style2':
			$template = 'post-grid-2';
			break;
			case 'style3':
			$template = 'post-grid-3';
			break;
			default:
			$template = 'post-grid-1';
			break;
		}

		return $this->rt_template( $template, $data );
	}
}