<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Barta_Core;

use Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) exit;

class Progress_Circle extends Custom_Widget_Base {

    public function __construct( $data = [], $args = null ){
        $this->rt_name = __( 'Progress Circle', 'barta-core' );
        $this->rt_base = 'rt-progress-circle';
        parent::__construct( $data, $args );
    }

    private function rt_load_scripts(){
        wp_enqueue_style( 'animate' );
		wp_enqueue_script( 'knob' );
		wp_enqueue_script( 'appear' );
    }

    public function rt_fields(){
        $fields = array(
            array(
                'mode'    => 'section_start',
                'id'      => 'sec_general',
                'label'   => __( 'General', 'barta-core' ),
            ),
            array(
                'type'    => Controls_Manager::TEXT,
                'id'      => 'title',
                'label'   => __( 'Title', 'barta-core' ),
                'default' => 'Deposite',
            ),
            array(
                'type'    => Controls_Manager::SLIDER,
                'id'      => 'percentage',
                'label'   => __( 'Percentage', 'barta-core' ),
                'default' => array( 'size' => 90 ),
            ),
            array(
                'type'    => Controls_Manager::COLOR,
                'id'      => 'bgcolor',
                'label'   => __( 'Background Color', 'barta-core' ),
                'default' => '#ffbe00',                
            ),
            array(
                'type'    => Controls_Manager::COLOR,
                'id'      => 'fgcolor',
                'label'   => __( 'Foreground', 'barta-core' ),
                'default' => '#ffbe00',                
            ),
			array(
                'type'    => Controls_Manager::TEXT,
                'id'      => 'circle_width',
                'label'   => __( 'Width', 'barta-core' ),
                'default' => '140',                
            ),
			array(
                'type'    => Controls_Manager::TEXT,
                'id'      => 'circle_height',
                'label'   => __( 'Height', 'barta-core' ),
                'default' => '140',                
            ),
            array(
                'mode' => 'section_end',
            ),
        );
        return $fields;
    }

    protected function render() {
        $data = $this->get_settings();
        $this->rt_load_scripts();

        $template = 'progress-circle';

        return $this->rt_template( $template, $data );
    }
}