<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Barta_Core;

use Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) exit;

class Title extends Custom_Widget_Base {

	public function __construct( $data = [], $args = null ){
		$this->rt_name = __( 'RT Section Title', 'barta-core' );
		$this->rt_base = 'rt-title';
		parent::__construct( $data, $args );
	}

	public function rt_fields(){
		$fields = array(
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_general',
				'label'   => __( 'News Title', 'barta-core' ),
			),
			/*box title*/
			array(
				'label'			=> esc_html__( 'Show Title', 'barta-core' ),
				'type'  		=> Controls_Manager::SWITCHER,
				'id'			=> 'has_sec_title',
				'label_on'		=> esc_html__( 'Show', 'barta-core' ),
				'label_off' 	=> esc_html__( 'Hide', 'barta-core' ),
				'return_value'	=> 'yes',
				'default'		=> 'yes',				
			),
			array(
				'type'    => Controls_Manager::TEXTAREA,
				'id'      => 'title',
				'label'   => __( 'Title', 'barta-core' ),
				'default' => 'News',
				'condition' => array( 'has_sec_title' => array( 'yes' ) ),
			),			
			/*Title Style Option*/
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'title_style',
				'label'   => __( 'Title Style', 'barta-core' ),
				'options' => array(
					'style_1' => __( 'Style 1' , 'barta-core' ),
					'style_2' => __( 'style 2', 'barta-core' ),
				),
				'default' => 'style_2',
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'title_color',
				'label'   => __( 'Section Title Color', 'barta-core' ),
				'default' => '#ffffff',
				'selectors' => array(
					'{{WRAPPER}} .el-rt-news-box-title' => 'color: {{VALUE}}',
				),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'title_bg_color',
				'label'   => __( 'Section Title Background Color', 'barta-core' ),
				'default' => '#111111',
				'selectors' => array( 
					'{{WRAPPER}} .el-rt-news-box-title.style_2' => 'background: {{VALUE}}',
					'{{WRAPPER}} .el-rt-news-box-title.style_2 .titleinner' => 'border-top-color: {{VALUE}}',
					'{{WRAPPER}} .rt-news-box-title-holder' => 'border-color: {{VALUE}}',
					'{{WRAPPER}} .el-rt-news-box-title.style_1' => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .el-rt-news-box-title.style_1 .titleinner' => 'border-top-color: {{VALUE}}',
										
				),
			),
			array(
				'mode' => 'section_end',
			),
		);
		return $fields;
	}

	protected function render() {
		$data = $this->get_settings();

		$template = 'title';

		return $this->rt_template( $template, $data );
	}
}