<?php
if ( post_password_required() ) {
    return;
}
?>
<div id="comments" class="comments-area single-blog-bottom">
    <?php
		if ( have_comments() ):
		$barta_comment_count = get_comments_number();
		$barta_comments_text = number_format_i18n( $barta_comment_count ) . ' ';
		
		$barta_comment_count = get_comments_number();
		$barta_comments_text = number_format_i18n( $barta_comment_count );
		
		if ( $barta_comment_count > 1 ) {
			$barta_comments_text .= esc_html__( ' Comments', 'barta' );
		}
		else{
			$barta_comments_text .= esc_html__( ' Comment', 'barta' );
		}
	?>
		<h4><?php echo esc_html( $barta_comments_text );?></h4>
		<?php
			$barta_avatar = get_option( 'show_avatars' );
			$get_theme_options = get_option('barta');
			if ( !empty($get_theme_options['blog_star_rating']) && ($get_theme_options['blog_star_rating'] == 1) ) {
		?>
		<div class="avarage-rating-wrap">
			<div><?php echo esc_html( 'Avarage Rating', 'barta' );  ?>:  <?php barta_get_comments_rating_avg_star(); ?></div>
		</div>
		<?php } ?>
		<ul class="comment-list<?php echo empty( $barta_avatar ) ? ' avatar-disabled' : '';?>">
		<?php
			wp_list_comments(
				array(
					'style'             => 'ul',
					'callback'          => 'BartaTheme_Helper::comments_callback',
					'reply_text'        => '<i class="fa fa-mail-forward" aria-hidden="true"></i> '. esc_html__( 'Reply', 'barta' ),
					'avatar_size'       => 105,
					'format'            => 'html5',
					) 
				);
		 ?>
		</ul>
		<?php if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) : // Are there comments to navigate through? ?>
			<nav class="pagination-area comment-navigation">
				<ul>
					<li><?php previous_comments_link( esc_html__( 'Older Comments', 'barta' ) ); ?></li>
					<li><?php next_comments_link( esc_html__( 'Newer Comments', 'barta' ) ); ?></li>
				</ul>
			</nav><!-- #comment-nav-below -->
		<?php endif; // Check for comment navigation.?>
	<?php endif; ?>

	<?php if ( ! comments_open() && get_comments_number() && post_type_supports( get_post_type(), 'comments' ) ) : ?>
		<p class="no-comments"><?php esc_html_e( 'Comments are closed.', 'barta' ); ?></p>
	<?php endif;?>
	<div>
	<?php
		$barta_commenter = wp_get_current_commenter();
		$barta_req = get_option( 'require_name_email' );
		$barta_aria_req = ( $barta_req ? " required" : '' );

		$barta_fields =  array(
			'author' =>
			'<div class="row"><div class="col-sm-6"><div class="form-group comment-form-author"><input type="text" id="author" name="author" value="' . esc_attr( $barta_commenter['comment_author'] ) . '" placeholder="'. esc_attr__( 'Name', 'barta' ).( $barta_req ? ' *' : '' ).'" class="form-control"' . $barta_aria_req . '></div></div>',

			'email' =>
			'<div class="col-sm-6 comment-form-email"><div class="form-group"><input id="email" name="email" type="email" value="' . esc_attr(  $barta_commenter['comment_author_email'] ) . '" class="form-control" placeholder="'. esc_attr__( 'Email', 'barta' ).( $barta_req ? ' *' : '' ).'"' . $barta_aria_req . '></div></div></div>',
			);

		$barta_args = array(
			'class_submit'      => 'submit btn-send ghost-on-hover-btn',
			'submit_field'         => '<div class="form-group form-submit">%1$s %2$s</div>',
			'comment_field' =>  '<div class="form-group comment-form-comment"><textarea id="comment" name="comment" required placeholder="'.esc_attr__( 'Comment *', 'barta' ).'" class="textarea form-control" rows="10" cols="40"></textarea></div>',
			'title_reply_before' => '<h4 id="reply-title" class="comment-reply-title">',
			'title_reply_after' => '</h4>',
			'fields' => apply_filters( 'comment_form_default_fields', $barta_fields ),
			);
			?>
		<?php comment_form( $barta_args );?>
	</div>
</div>