<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

$barta_footer_column = BartaTheme::$options['footer_column'];
switch ( $barta_footer_column ) {
	case '1':
	$barta_footer_class = 'col-lg-12 col-sm-12 col-xs-12';
	break;
	case '2':
	$barta_footer_class = 'col-lg-6 col-sm-6 col-xs-12';
	break;
	case '3':
	$barta_footer_class = 'col-lg-4 col-sm-4 col-xs-12';
	break;		
	default:
	$barta_footer_class = 'col-lg-3 col-sm-6 col-xs-12';
	break;
}

$barta_light_logo = empty( BartaTheme::$options['footer_logo_light']['id'] ) ? '<img width="190" height="50" alt="'.get_bloginfo( 'name' ).'" src="'.BARTA_IMG_URL.'logo-light.png'.'">' : wp_get_attachment_image(BartaTheme::$options['footer_logo_light']['id'],'full');
$barta_socials = BartaTheme_Helper::socials();

?>
</div><!--#content-->
	<!-- ad start -->
	<?php
		$is_ad_active2 = get_post_meta( get_the_ID(), 'barta_footer_ad', true );
		if ( $is_ad_active2 == 'on' ) {
			do_action( 'barta_before_footer' );
		}	
	?>	
	<!-- ad end -->
<footer>
<?php 
 if ( BartaTheme_Helper::has_footer() ){ ?>
	<div class="footer-top-area">
		<div class="container">
			<div class="row">
				<?php
				for ( $i = 1; $i <= $barta_footer_column; $i++ ) {
					echo '<div class="' . $barta_footer_class . '">';
					dynamic_sidebar( 'footer-'. $i );
					echo '</div>';
				}
				?>
			</div>
		</div>
	</div>
<?php } ?>
<?php if ( BartaTheme::$options['copyright_area'] ): ?>
	<div class="footer-bottom-area">
		<div class="container">
			<div class="row">
				<div class="footer-logo"><a class="dark-logo" href="<?php echo esc_url( home_url( '/' ) );?>"><?php echo $barta_light_logo;?></a></div>
				<div class="footer-bottom-social">
				<?php if ( $barta_socials ): ?>
					<ul class="tophead-social">
						<?php foreach ( $barta_socials as $barta_social ): ?>
							<li><a target="_blank" href="<?php echo esc_url( $barta_social['url'] );?>"><i class="fa <?php echo esc_attr( $barta_social['icon'] );?>"></i></a></li>
						<?php endforeach; ?>
					</ul>
				<?php endif; ?>
				</div>
				<div class="col-sm-12 col-xs-12"><?php echo wp_kses_post( BartaTheme::$options['copyright_text'] );?></div>
			</div>
		</div>
	</div>
<?php endif; ?>
</footer>
<?php if ( ( BartaTheme::$options['scroll_indicator_enable'] == '1' ) && ( BartaTheme::$options['scroll_indicator_position'] == 'below' ) ){ ?>
<div class="barta-progress-container bottom">
	<div class="barta-progress-bar" id="bartaBar"></div>
</div>
<?php } ?>
</div>
<?php wp_footer();?>
</body>
</html>