<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

if ( !isset( $content_width ) ) {
	$content_width = 1200;
}

add_action('after_setup_theme', 'barta_setup');
if ( !function_exists( 'barta_setup' ) ) {
	function barta_setup() {
		// Language
		load_theme_textdomain( 'barta', BARTA_BASE_DIR . 'languages' );

		// Theme support
		add_theme_support( 'title-tag' );
		add_theme_support( 'post-thumbnails' );
		add_theme_support( 'automatic-feed-links' );
		add_theme_support( 'html5', array( 'comment-list', 'comment-form', 'search-form', 'gallery', 'caption' ) );
		add_theme_support( 'post-formats', array( 'aside', 'gallery', 'video', 'audio' ) );
		add_theme_support( 'woocommerce' );
		// for gutenberg support
		add_theme_support( 'align-wide' );
		
		// Image sizes
		add_image_size( 'barta-size1', 1200, 600, true ); // post/news large
		add_image_size( 'barta-size2', 598, 487, true ); // FOR ADDON: rt-news-box , Half box( col-6 ), grid3,
		add_image_size( 'barta-size3', 375, 300, true ); // small image for side bar
		add_image_size( 'barta-size4', 700, 1015, true ); // Portert Image -- all protrait Img 
		add_image_size( 'barta-size5', 555, 370, true ); // Grid 1 , Grid 9
		add_image_size( 'barta-size6', 350, 254, true ); // in the blog page -layout 2 - news
		add_image_size( 'barta-size7', 556, 346, true ); // in news grid 2
		add_image_size( 'barta-size8', 560, 404, true ); // in the blog page -layout 1 - news		
		add_image_size( 'barta-size9', 278, 326, true ); // rt-news-list 1	
		add_image_size( 'barta-size10', 152, 136, true ); // small image for side bar
		add_image_size( 'barta-size11', 700, 850, true ); // tab 3
		add_image_size( 'barta-size12', 500, 511, true ); // box-9(big)
		add_image_size( 'barta-size13', 670, 324, true ); // box-3( side Left )
		add_image_size( 'barta-size14', 400, 323, true ); // box-3( side right )		
		
		// Register menus
		register_nav_menus( array(
			'primary'  => esc_html__( 'Primary', 'barta' ),
		) );
		
		add_theme_support( 'wp-block-styles' );
		add_theme_support( 'responsive-embeds' );
		add_theme_support('editor-styles');	

		remove_theme_support( 'widgets-block-editor' );
	}
}

function barta_theme_add_editor_styles() {
	add_editor_style( get_stylesheet_uri() );
}
add_action( 'admin_init', 'barta_theme_add_editor_styles' );

// Initialize Widgets
add_action( 'widgets_init', 'barta_widgets_register' );
if ( !function_exists( 'barta_widgets_register' ) ) {
	function barta_widgets_register() {
		
		$footer_widget_titles = array(
			'1' => esc_html__( 'Footer 1', 'barta' ),
			'2' => esc_html__( 'Footer 2', 'barta' ),
			'3' => esc_html__( 'Footer 3', 'barta' ),
			'4' => esc_html__( 'Footer 4', 'barta' ),
		);

		// Register Widget Areas ( Common )
		register_sidebar( array(
			'name'          => esc_html__( 'Sidebar', 'barta' ),
			'id'            => 'sidebar',
			'before_widget' => '<div id="%1$s" class="widget %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<div class="rt-widget-title-holder"><h3 class="widgettitle">',
			'after_title'   => '<span class="titleinner"></span></h3></div>',
			) );
		
		register_sidebar( array(
			'name'          => esc_html__( 'Top Bar 4 - Left', 'barta' ),
			'id'            => 'top4-left',
			'before_widget' => '<div id="%1$s" class="widget %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h3 class="hidden">',
			'after_title'   => '</h3>',
		) );

		register_sidebar( array(
			'name'          => esc_html__( 'Top Bar 4 - Right', 'barta' ),
			'id'            => 'top4-right',
			'before_widget' => '<div id="%1$s" class="widget %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h3 class="hidden">',
			'after_title'   => '</h3>',
		) );
		
		for ( $i = 1; $i <= BartaTheme::$options['footer_column']; $i++ ) {
			register_sidebar( array(
				'name'          => $footer_widget_titles[$i],
				'id'            => 'footer-'. $i,
				'before_widget' => '<div id="%1$s" class="widget %2$s">',
				'after_widget'  => '</div>',
				'before_title'  => '<h3 class="widgettitle">',
				'after_title'   => '</h3>',
			) );		
		}
	}
}

// Head Script
add_action( 'wp_head', 'barta_head', 1 );
if( !function_exists( 'barta_head' ) ) {
	function barta_head(){
		// Hide preloader if js is disabled
		echo '<noscript><style>#preloader{display:none;}</style></noscript>';
	}	
}

// Footer Html
add_action( 'wp_footer', 'barta_footer_html', 1 );
if( !function_exists( 'barta_footer_html' ) ) {
	function barta_footer_html(){
		// Back-to-top link
		if ( BartaTheme::$options['back_to_top'] ){
			echo '<a href="#" class="scrollToTop"><i class="fa fa-arrow-up"></i></a>';
		}
	}	
}

// advanced search functionality
function advanced_search_query($query) {

    if($query->is_search()) {
        // category terms search.
        if (isset($_GET['category']) && !empty($_GET['category'])) {
            $query->set('tax_query', array(array(
                'taxonomy' => 'product_cat',
                'field' => 'slug',
                'terms' => array($_GET['category']) )
            ));
        }    
    }
    return $query;
}
add_action('pre_get_posts', 'advanced_search_query', 1000);

/*social link to author profile page*/
add_action( 'show_user_profile', 'barta_user_social_profile_fields' );
add_action( 'edit_user_profile', 'barta_user_social_profile_fields' );

function barta_user_social_profile_fields( $user ) { ?>

	<h3><?php esc_html_e( 'User Designation' , 'barta' ); ?></h3>

	<table class="form-table">
		<tr>
			<th><label for="barta_author_designation"><?php esc_html_e( 'Author Designation' , 'barta' ); ?></label></th>
			<td><input type="text" name="barta_author_designation" id="barta_author_designation" value="<?php echo esc_attr( get_the_author_meta( 'barta_author_designation', $user->ID ) ); ?>" class="regular-text" /><br /><span class="description"><?php esc_html_e( 'Please enter your Author Designation' , 'barta' ); ?></span></td>
		</tr>
	</table>
	
	<h3><?php esc_html_e( 'Social profile information' , 'barta' ); ?></h3>

	<table class="form-table">
		<tr>
			<th><label for="facebook"><?php esc_html_e( 'Facebook' , 'barta' ); ?></label></th>
			<td><input type="text" name="facebook" id="facebook" value="<?php echo esc_attr( get_the_author_meta( 'barta_facebook', $user->ID ) ); ?>" class="regular-text" /><br /><span class="description"><?php esc_html_e( 'Please enter your facebook URL.' , 'barta' ); ?></span></td>
		</tr>
		<tr>
			<th><label for="twitter"><?php esc_html_e( 'Twitter' , 'barta' ); ?></label></th>
			<td><input type="text" name="twitter" id="twitter" value="<?php echo esc_attr( get_the_author_meta( 'barta_twitter', $user->ID ) ); ?>" class="regular-text" /><br /><span class="description"><?php esc_html_e( 'Please enter your Twitter username.' , 'barta' ); ?></span></td>
		</tr>
		<tr>
			<th><label for="linkedin"><?php esc_html_e( 'LinkedIn' , 'barta' ); ?></label></th>
			<td><input type="text" name="linkedin" id="linkedin" value="<?php echo esc_attr( get_the_author_meta( 'barta_linkedin', $user->ID ) ); ?>" class="regular-text" /><br /><span class="description"><?php esc_html_e( 'Please enter your LinkedIn Profile' , 'barta' ); ?></span></td>
		</tr>
		<tr>
			<th><label for="gplus"><?php esc_html_e( 'Google+' , 'barta' ); ?></label></th>
			<td><input type="text" name="gplus" id="gplus" value="<?php echo esc_attr( get_the_author_meta( 'barta_gplus', $user->ID ) ); ?>" class="regular-text" /><br /><span class="description"><?php esc_html_e( 'Please enter your google+ Profile' , 'barta' ); ?></span></td>
		</tr>
		<tr>
			<th><label for="pinterest"><?php esc_html_e( 'Pinterest' , 'barta' ); ?></label></th>
			<td><input type="text" name="pinterest" id="pinterest" value="<?php echo esc_attr( get_the_author_meta( 'barta_pinterest', $user->ID ) ); ?>" class="regular-text" /><br /><span class="description"><?php esc_html_e( 'Please enter your Pinterest Profile' , 'barta' ); ?></span></td>
		</tr>
	</table>
<?php }

add_action( 'personal_options_update', 'barta_extra_profile_fields' );
add_action( 'edit_user_profile_update', 'barta_extra_profile_fields' );

function barta_extra_profile_fields( $user_id ) {

	if ( !current_user_can( 'edit_user', $user_id ) )
		return false;

	update_user_meta( $user_id, 'barta_facebook', $_POST['facebook'] );
	update_user_meta( $user_id, 'barta_twitter', $_POST['twitter'] );
	update_user_meta( $user_id, 'barta_linkedin', $_POST['linkedin'] );
	update_user_meta( $user_id, 'barta_gplus', $_POST['gplus'] );
	update_user_meta( $user_id, 'barta_pinterest', $_POST['pinterest'] );
	update_user_meta( $user_id, 'barta_author_designation', $_POST['barta_author_designation'] );
}

/*find newest post/product with time*/
function barta_is_new( $id ) {
	$now    = time();
	$published_date = get_post_time('U');
	$diff =  $now - $published_date;
	if ( $diff < 604800 ) { ?>
		<span class="new-post"><?php esc_html_e( 'New' , 'barta' ); ?></span>
	<?php }
}

if( ! function_exists( 'barta_post_img_src' )){
	function barta_post_img_src( $size = 'barta-size1' ){
		$post_id  = get_the_ID();
		$image_id = get_post_thumbnail_id( $post_id );
		$image    = wp_get_attachment_image_src( $image_id, $size );
		return $image[0];
	}
}

/*Post Time & time format*/
if( ! function_exists( 'barta_get_time' )){

	function barta_get_time( $return = false ){

		$post = get_post();
		
		# Date is disabled globally ----------
		if( BartaTheme::$options['time_format'] == 'none' ){
			return false;
		}
		# Human Readable Post Dates ----------
		elseif(  BartaTheme::$options['time_format'] == 'modern' ){

			$time_now  = current_time( 'timestamp' );
			$post_time = get_the_time( 'U' ) ;
			$since = sprintf( esc_html__( '%s ago' , 'barta' ), human_time_diff( $post_time, $time_now ) );			
		}
		else{
			$since = get_the_date();
		}

		$post_time = '<span class="date meta-item"><span class="fa fa-clock-o" aria-hidden="true"></span>  <span>'.$since.'</span></span>';

		if( $return ){
			return $post_time;
		}

		echo wp_kses_post( $post_time );
	}

}

function widgets_scripts( $hook ) {
    if ( 'widgets.php' != $hook ) {
        return;
    }
    wp_enqueue_style( 'wp-color-picker' );
	
}
add_action( 'admin_enqueue_scripts', 'widgets_scripts' );

/*widget header style*/
add_action( 'in_widget_form', 'barta_in_widget_form',5,3 );
add_filter( 'widget_update_callback', 'barta_in_widget_form_update',5,3 );
add_filter( 'dynamic_sidebar_params', 'barta_dynamic_sidebar_params' );

function barta_in_widget_form( $t,$return,$instance ) {
    $instance = wp_parse_args( (array) $instance, array( 'title' => '', 'text' => '' ) );
    if ( !isset( $instance['radio_buttons'] ) )
        $instance['radio_buttons'] = 'title-style-2';
	if ( !isset( $instance['font_color'] ) )
		$instance['font_color'] = '#111';
    ?>
	<hr>	
	<div class="option-wrapper">
		<!-- radio button -->
		<p>			
			<p><?php esc_html_e( 'Title Style ( Not used in footer )', 'barta' ); ?></p>
			<br>
			<label for="<?php echo esc_attr( $t->get_field_id('radio_buttons') ); ?>">        
				<input class="common_radio" id="<?php echo esc_attr( $t->get_field_id( 'title-style-2' ) ); ?>" name="<?php echo esc_attr( $t->get_field_name( 'radio_buttons' ) ); ?>" type="radio" value="title-style-2" data-val="<?php echo esc_attr( $radio_buttons ); ?>" <?php if ( $instance['radio_buttons'] === 'title-style-2' ){ echo 'checked="checked"'; } ?> />
				<img alt="title style 1" src="<?php echo BARTA_IMG_URL . 'header_style_1.png' ?>" />
			</label>
			<label for="<?php echo esc_attr( $t->get_field_id('radio_buttons')); ?>">        
				<input class="common_radio" id="<?php echo esc_attr( $t->get_field_id( 'title-style-1' ) ); ?>" name="<?php echo esc_attr( $t->get_field_name('radio_buttons')); ?>" type="radio" value="title-style-1" <?php if( $instance['radio_buttons'] === 'title-style-1' ){ echo esc_attr('checked="checked"'); } ?> />
				<img alt="title style 1" src="<?php echo BARTA_IMG_URL . 'header_style_2.png' ?>" />
			</label>
		</p>
		<p>
			<label for="<?php echo esc_attr( $t->get_field_id( 'font_color' )) ; ?>"><?php esc_html_e( 'Title Background Color:' , 'barta' ); ?></label> 
			<input class="widefat color-picker" id="<?php echo esc_attr( $t->get_field_id( 'font_color' )); ?>" name="<?php echo esc_attr( $t->get_field_name( 'font_color' )); ?>" type="text" value="<?php echo esc_attr( $instance['font_color'] ); ?>" />
		</p>
	</div>
    <?php
    $retrun = null;
		return array( $t,$return,$instance );
	}
	function barta_in_widget_form_update( $instance, $new_instance, $old_instance ) {
		if (isset($instance['radio_buttons']) ) {

			if ( isset($instance['font_color']) ) {			
				$instance['radio_buttons'] = $new_instance['radio_buttons'];
				$instance['font_color'] = $new_instance['font_color'];				
			}
		} else {
			$instance['radio_buttons'] = 'title-style-2';
			$instance['font_color'] = '#111';
		}
		
		return $instance;
	}

	function barta_dynamic_sidebar_params( $params ) {
		global $wp_registered_widgets;
		$widget_id = $params[0]['widget_id'];
		$widget_obj = $wp_registered_widgets[$widget_id];
		$widget_opt = get_option($widget_obj['callback'][0]->option_name);
		$widget_num = $widget_obj['params'][0]['number'];
				
		if( isset($widget_opt[$widget_num]['radio_buttons'] ) ) {
			$radio_option = $widget_opt[$widget_num]['radio_buttons'];
		} else {
			$radio_option = 'title-style-2';
		}
				
		if( !empty( $widget_opt[$widget_num]['font_color'] ) ) {
			$font_color = $widget_opt[$widget_num]['font_color'];
		} else {
			$font_color = '#111';
		}
				
		$params[0]['before_widget'] = preg_replace( '/class="/', ' class="'  . $radio_option .' ',  $params[0]['before_widget'], 1 );

		$target_string = $params[0]['before_title'];
		
		$position_div =  strpos($target_string, "<div");
		if( $position_div !== false ){
			$position_div = $position_div + 5;
			$target_string = substr_replace($target_string, " style='border-bottom: 2px solid {$font_color}' " , $position_div, 0);
		}
		
		$position =  strpos($target_string, "<h3");
		if( $position !== false ){
			$position = $position + 4;
			$target_string = substr_replace($target_string, " style='background-color: {$font_color}' " , $position, 0);
		}	
		
		$params[0]['before_title'] = $target_string;
		
		$target_span = $params[0]['after_title'];
		$position_span =  strpos($target_span, "<span");
		if($position_span !== false){
			$position_span = $position_span + 5;
			$params[0]['after_title'] = substr_replace($target_span, " style='border-top: 10px solid {$font_color}' " , $position_span, 0);
		}
		
		return $params;
	}

function load_custom_wp_admin_style() {
	wp_register_style( 'wp-admin-css', BARTA_CSS_URL . 'admin-style.css', array(), BARTA_VERSION );
	wp_enqueue_style( 'wp-admin-css' );
	wp_enqueue_style( 'wp-color-picker' );
	wp_enqueue_script( 'rt-widget-color', BARTA_JS_URL . 'rt-widget-color.js', array( 'jquery','wp-color-picker' ), BARTA_VERSION, true );
}
add_action( 'admin_enqueue_scripts', 'load_custom_wp_admin_style' );

/*Module: Last Post update Date*/
function barta_last_update() {

	$lastupdated_args = array(
		'orderby' => 'modified',
		'posts_per_page' => 1,
		'ignore_sticky_posts' => '1'
	);
 
	$lastupdated_loop = new WP_Query( $lastupdated_args );
	
	while( $lastupdated_loop->have_posts() )  {
		$lastupdated_loop->the_post();		
		echo get_post_modified_time(get_option( 'date_format' ) .' '. get_option( 'time_format' ), false, null, true);
	}	
	wp_reset_postdata();
}

/*
* for most use of the get_term cached 
* This is because all time it hits and single page provide data quickly
*/
function get_img( $img ){
	$img = get_stylesheet_directory_uri() . '/assets/img/' . $img;
	return $img;
}
function get_css( $file ){
	$file = get_stylesheet_directory_uri() . '/assets/css/' . $file . '.css';
	return $file;
}
function get_js( $file ){
	$file = get_stylesheet_directory_uri() . '/assets/js/' . $file . '.js';
	return $file;
}
function filter_content( $content ){
	// wp filters
	$content = wptexturize( $content );
	$content = convert_smilies( $content );
	$content = convert_chars( $content );
	$content = wpautop( $content );
	$content = shortcode_unautop( $content );

	// remove shortcodes
	$pattern= '/\[(.+?)\]/';
	$content = preg_replace( $pattern,'',$content );

	// remove tags
	$content = strip_tags( $content );

	return $content;
}

function get_current_post_content( $post = false ) {
	if ( !$post ) {
		$post = get_post();				
	}
	$content = has_excerpt( $post->ID ) ? $post->post_excerpt : $post->post_content;
	$content = filter_content( $content );
	return $content;
}

function cached_get_term_by( $field, $value, $taxonomy, $output = OBJECT, $filter = 'raw' ){
	// ID lookups are cached
	if ( 'id' == $field )
		return get_term_by( $field, $value, $taxonomy, $output, $filter );

	$cache_key = $field . '|' . $taxonomy . '|' . md5( $value );
	$term_id = wp_cache_get( $cache_key, 'get_term_by' );

	if ( false === $term_id ){
		$term = get_term_by( $field, $value, $taxonomy );
		if ( $term && ! is_wp_error( $term ) )
			wp_cache_set( $cache_key, $term->term_id, 'get_term_by' );
		else
			wp_cache_set( $cache_key, 0, 'get_term_by' ); // if we get an invalid value, let's cache it anyway
	} else {
		$term = get_term( $term_id, $taxonomy, $output, $filter );
	}

	if ( is_wp_error( $term ) )
		$term = false;

	return $term;
}

/*for avobe reason*/
function cached_get_term_link( $term, $taxonomy = null ){
	// ID- or object-based lookups already result in cached lookups, so we can ignore those.
	if ( is_numeric( $term ) || is_object( $term ) ){
		return get_term_link( $term, $taxonomy );
	}

	$term_object = cached_get_term_by( 'slug', $term, $taxonomy );
	return get_term_link( $term_object );
}


/*only to show the first category in the post - primary category*/
function barta_if_term_exists( $term, $taxonomy = '', $parent = null ){
	if ( null !== $parent ){
		return term_exists( $term, $taxonomy, $parent );
	}

	if ( ! empty( $taxonomy ) ){
		$cache_key = $term . '|' . $taxonomy;
	}else{
		$cache_key = $term;
	}

	$cache_value = wp_cache_get( $cache_key, 'term_exists' );

	//term_exists frequently returns null, but (happily) never false
	if ( false  === $cache_value ){
		$term_exists = term_exists( $term, $taxonomy );
		wp_cache_set( $cache_key, $term_exists, 'term_exists' );
	}else{
		$term_exists = $cache_value;
	}

	if ( is_wp_error( $term_exists ) )
		$term_exists = null;

	return $term_exists;
}


if( ! function_exists( 'barta_get_primary_category' )){

	function barta_get_primary_category() {

		if( get_post_type() != 'post' ) {
			return;
		}

		# Get the first assigned category ----------
			$get_the_category = get_the_category();
			$primary_category = array( $get_the_category[0] );

		if( ! empty( $primary_category[0] )) {
			return $primary_category;
		}
	}
}

/*only to show the first category in the post - primary category ID*/
if( ! function_exists( 'barta_get_primary_category_id' )){

	function barta_get_primary_category_id(){

		$primary_category = barta_get_primary_category();

		if( ! empty( $primary_category[0]->term_id )){
			return $primary_category[0]->term_id;
		}

		return false;
	}
}
/*For category color*/
if ( ! function_exists ( 'barta_category_prepare' ) ) {
		
	function barta_category_prepare() {
	$get_color  = get_term_meta( barta_get_primary_category()[0]->term_id , 'rt_category_color', true );
	
	if ( $get_color ) {	?>
		<a href="<?php echo get_category_link( barta_get_primary_category()[0]->term_id ); ?>"><span class="el-rt-cat style_2" style="background:#<?php echo esc_attr( $get_color ); ?>"><?php echo esc_html( barta_get_primary_category()[0]->name ); ?><span class="titleinner" style="border-top: 8px solid #<?php echo esc_attr( $get_color ); ?>;" ></span></span></a>
	<?php } else { ?>
		<a href="<?php echo get_category_link( barta_get_primary_category()[0]->term_id ); ?>"><span class="el-rt-cat style_2"><?php echo esc_html( barta_get_primary_category()[0]->name ); ?><span class="titleinner"></span></span></a>
	<?php } 
	
	}
}
/*For Selected category color*/
if ( ! function_exists ( 'barta_sel_category_prepare' ) ) {
		
	function barta_sel_category_prepare( $sel_cat_id ) {
	$get_color  = get_term_meta( $sel_cat_id , 'rt_category_color', true );
	
	if ( $get_color ) {	?>
		<a href="<?php echo get_category_link( $sel_cat_id ); ?>"><span class="el-rt-cat style_2" style="background:#<?php echo esc_attr( $get_color ); ?>"><?php echo get_cat_name( $sel_cat_id );; ?><span class="titleinner" style="border-top: 8px solid #<?php echo esc_attr( $get_color ); ?>;" ></span></span></a>
	<?php } else { ?>
		<a href="<?php echo get_category_link( barta_get_primary_category()[0]->term_id ); ?>"><span class="el-rt-cat style_2"><?php echo esc_html( barta_get_primary_category()[0]->name ); ?><span class="titleinner"></span></span></a>
	<?php } 
	
	}
}
/*add category color meta*/
function barta_colorpicker_field_add_new_category( $taxonomy ) {
  ?>
    <div class="form-field term-colorpicker-wrap">
        <label for="term-colorpicker"><?php esc_html_e( 'Category Color', 'barta' ); ?></label>
        <input name="rt_category_color" value="#111111" class="colorpicker" id="term-colorpicker" />
        <p><?php esc_html_e( 'This is category background color.', 'barta' ); ?></p>
    </div>
  <?php
}
add_action( 'category_add_form_fields', 'barta_colorpicker_field_add_new_category' );
function barta_colorpicker_field_edit_category( $term ) {
    $color = get_term_meta( $term->term_id, 'rt_category_color', true );
    $color = ( ! empty( $color ) ) ? "#{$color}" : '#111111';
  ?>
    <tr class="form-field term-colorpicker-wrap">
        <th scope="row"><label for="term-colorpicker"><?php esc_html_e( 'Category Color', 'barta' ); ?></label></th>
        <td>
            <input name="rt_category_color" value="<?php echo esc_attr( $color ); ?>" class="colorpicker" id="term-colorpicker" />
            <p class="description"><?php esc_html_e( 'This is category background color.', 'barta' ); ?></p>
        </td>
    </tr>
  <?php
}
add_action( 'category_edit_form_fields', 'barta_colorpicker_field_edit_category' ); 

function barta_save_termmeta( $term_id ) {
    // Save term color if possible
    if( isset( $_POST['rt_category_color'] ) && ! empty( $_POST['rt_category_color'] ) ) {
        update_term_meta( $term_id, 'rt_category_color', sanitize_hex_color_no_hash( $_POST['rt_category_color'] ) );
    } else {
        delete_term_meta( $term_id, 'rt_category_color' );
    }
}
add_action( 'created_category', 'barta_save_termmeta' );
add_action( 'edited_category',  'barta_save_termmeta' );

function barta_category_colorpicker_enqueue( $taxonomy ) {
    if( null !== ( $screen = get_current_screen() ) && 'edit-category' !== $screen->id ) {
        return;
    }
    // Colorpicker Scripts
    wp_enqueue_script( 'wp-color-picker' );
    // Colorpicker Styles
    wp_enqueue_style( 'wp-color-picker' );

}
add_action( 'admin_enqueue_scripts', 'barta_category_colorpicker_enqueue' );

//Category Color column
add_filter( 'manage_edit-category_columns', 'barta_edit_term_columns', 10, 3 );
function barta_edit_term_columns( $columns ) {
    $columns['rt_category_color'] = esc_html__( 'Category Color', 'barta' );
    return $columns;
}
// RENDER COLUMNS
add_filter( 'manage_category_custom_column', 'barta_manage_term_custom_column', 10, 3 );
function barta_manage_term_custom_column( $out, $column, $term_id ) {
    if ( 'rt_category_color' === $column ) {
        $value  = get_term_meta( $term_id , 'rt_category_color', true );
        if ( ! $value )
            $value = '';
        $out = sprintf( '<span class="term-meta-color-block" style="background:#%s" ></span>', esc_attr( $value ) );
    }
    return $out;
}
//find the post type function 
if ( ! function_exists ( 'barta_post_type' ) ) {
	function barta_post_type() {
		$barta_post_type_var =get_post_type( get_the_ID());
		echo esc_html( $barta_post_type_var );
	}
}

/*get the avarage*/
function barta_get_comments_rating_avg() {
	$vote = 0;
	$i = 0;
	$comments_ratings = get_comments ( array ( 'post_id' => get_the_ID(),'meta_key'=> 'recipe_rating' ) );
	
	foreach( $comments_ratings as $comments_rating ) {
		$vote += intval ( get_comment_meta( $comments_rating->comment_ID, 'recipe_rating', true ) );
		$i++;
	}
	if ( $i != 0 ) {
		$avarage = $vote / $i;
	
		$final_avarage = round( $avarage );
	} else {
		$final_avarage = 0;
	}
	
	return $final_avarage;
}

/*get the avarage with star Rating*/
function barta_get_comments_rating_avg_star() {
	
	$star_count = barta_get_comments_rating_avg();
	
	echo wp_kses_post('<ul class="avg item-rating">');
	$y = 1;
	for ( $x = 1; $x <= 5; $x++ ) { 
		if ( $x <= $star_count ) {
			echo wp_kses_post('<li class="single-item star-fill"><i class="fa fa-star"></i></li>');
			$y++;
		} else {
			echo wp_kses_post('<li class="single-item star-empty"><i class="fa fa-star"></i></li>');
		}
	}
	$point_count = barta_get_comments_rating_avg() * 2;
	echo '<li><span>' . $point_count . '<span> / 10</span></span> </li>';
	echo wp_kses_post('</ul>');	
}

/*next previous post links*/
if ( !function_exists( 'barta_post_links_next_prev' ) ) {
	function barta_post_links_next_prev() { ?>
	
	<div class="row no-gutters divider post-navigation">
	
		<?php if ( !empty( get_previous_post_link())){ ?>
			<div class="col-lg-6 col-md-6 col-sm-6 col-6 <?php if ( is_rtl() ){ echo esc_attr( 'text-right' ); } else { echo esc_attr( 'text-left' ); } ?>">
				<i class="fa fa-angle-<?php if ( is_rtl() ){ echo esc_attr( 'right' ); } else { echo esc_attr( 'left' ); } ?>" aria-hidden="true"></i>	<?php previous_post_link('%link', esc_html__('Previous article' , 'blogxer' ) , TRUE); ?>
				<?php previous_post_link('<h3 class="post-nav-title">%link</h3>'); ?>
			</div>
		<?php } ?>
		<?php if ( !empty( get_next_post_link())){ ?>
			<div class=" col-lg-6 col-md-6 col-sm-6 col-6 <?php if ( empty( get_previous_post_link())){ ?>offset-md-6<?php } ?> <?php if ( is_rtl() ){ echo esc_attr( 'text-left' ); } else { echo esc_attr( 'text-right' ); } ?>">
				<?php previous_post_link('%link', esc_html__('Next article' , 'blogxer' ) , TRUE); ?> <i class="fa fa-angle-<?php if ( is_rtl() ){ echo esc_attr( 'left' ); } else { echo esc_attr( 'right' ); } ?>" aria-hidden="true"></i></a>
				<?php next_post_link('<h3 class="post-nav-title">%link</h3>'); ?>
			</div>
		<?php } ?>
		
	</div>	
	
<?php }
}
/*Remove the archive label*/
function barta_archive_title( $title ) {
    if ( is_category() ) {
        $title = single_cat_title( '', false );
    } elseif ( is_tag() ) {
        $title = single_tag_title( '', false );
    } elseif ( is_author() ) {
        $title = '<span class="vcard">' . get_the_author() . '</span>';
    } elseif ( is_post_type_archive() ) {
        $title = post_type_archive_title( '', false );
    } elseif ( is_tax() ) {
        $title = single_term_title( '', false );
    }
  
    return $title;
}
 
add_filter( 'get_the_archive_title', 'barta_archive_title' );

/*Load More - Ajax*/
function barta_loadmore_ajax_handler(){	
	
	$paged = isset($_POST['paged']) ? (absint($_POST['paged']) + 1) : 1;
	
	$initial_post_num = get_option( 'posts_per_page' );
	
	$args = array(
		'paged' => $paged,
		'offset' =>  ($paged - 1) * $initial_post_num ,
		'posts_per_page' => $initial_post_num
	);
	
	$html = null;
	$more = true;
	if(isset($_POST['termId']) && $term_id = absint($_POST['termId'])){
		if(isset($_POST['taxonomy']) && $taxonomy = esc_attr($_POST['taxonomy'])){	
			if($taxonomy === "category"){
				$args['category__in'] = $term_id;
			}else if($taxonomy === "post_tag"){
				$args['tag__in'] = $term_id;
			}
		}
	}
	$layout_2 = $_POST['layout_2'];
	$layout_3 = $_POST['layout_3'];
	$layout_4 = $_POST['layout_4'];
	$layout_5 = $_POST['layout_5'];
	query_posts( $args );
	
	if( have_posts() ) {
		ob_start();
		// run the loop
		while( have_posts() ): the_post(); 
			
			if ( BartaTheme::$options['blog_style'] == 'style5' ) {				
				if ( $layout_5 == 'right-sidebar' || $layout_5 == 'left-sidebar' ) {
					get_template_part( 'template-parts/content-5-masonry-sidebar', get_post_format() );
				} else {
					get_template_part( 'template-parts/content-5-masonry-nosidebar', get_post_format() );
				}
			} else if ( BartaTheme::$options['blog_style'] == 'style4' ) {				
				if ( $layout_4 == 'right-sidebar' || $layout_4 == 'left-sidebar' ) {
					get_template_part( 'template-parts/content-4-masonry-sidebar', get_post_format() );
				} else {
					get_template_part( 'template-parts/content-4-masonry-nosidebar', get_post_format() );
				}
			} else if ( BartaTheme::$options['blog_style'] == 'style3' ) {
				get_template_part( 'template-parts/content-3', get_post_format() );
				
			} else if ( BartaTheme::$options['blog_style'] == 'style2' ) {
				if ( $layout_2 == 'right-sidebar' || $layout_2 == 'left-sidebar' ) {
					get_template_part( 'template-parts/content-2-sidebar', get_post_format() );
				} else {
					get_template_part( 'template-parts/content-2-nosidebar', get_post_format() );
				}				
			} else if ( BartaTheme::$options['blog_style'] == 'style1' ) {
				get_template_part( 'template-parts/content-1', get_post_format() );
			} 
 
		endwhile;
		$html = ob_get_clean();
 
	}else{
		$more = false;
	}	
	$data = $_POST;
	wp_send_json(compact('paged', 'html', 'more', 'data', 'args'));	
}
 
add_action('wp_ajax_barta_loadmore', 'barta_loadmore_ajax_handler'); // wp_ajax_{action}
add_action('wp_ajax_nopriv_barta_loadmore', 'barta_loadmore_ajax_handler'); // wp_ajax_nopriv_{action}

/*Infinity scroll - Ajax */
function barta_infinity_loading_ajax_handler(){
	
	$paged = isset($_POST['paged']) ? (absint($_POST['paged']) + 1) : 1;
	
	$num = BartaTheme::$options['infinity_post_load_number'];
	
	$initial_post_num = get_option( 'posts_per_page' );
	
	$args = array(
		
		'paged' => $paged,
		'offset' =>  ($paged - 1) * $initial_post_num ,
		'posts_per_page' => $initial_post_num,
		'post_status' => 'publish'
		
	);
    if(isset($_POST['termId']) && $term_id = absint($_POST['termId'])){
        if(isset($_POST['taxonomy']) && $taxonomy = esc_attr($_POST['taxonomy'])){
            if($taxonomy === "category"){
                $args['category__in'] = $term_id;
            }else if($taxonomy === "post_tag"){
                $args['tag__in'] = $term_id;
            }
        }
    }
	$html = null;
	$more = true;
	$layout_2 = $_POST['layout_2'];
	$layout_4 = $_POST['layout_4'];
	$layout_5 = $_POST['layout_5'];
	
	query_posts( $args );
 
	if( have_posts() ) {
		ob_start();
		// run the loop
		while( have_posts() ): the_post(); 
			
			if ( BartaTheme::$options['blog_style'] == 'style5' ) {				
				if ( $layout_5 == 'right-sidebar' || $layout_5 == 'left-sidebar' ) {
					get_template_part( 'template-parts/content-5-masonry-sidebar', get_post_format() );
				} else {
					get_template_part( 'template-parts/content-5-masonry-nosidebar', get_post_format() );
				}
			} else if ( BartaTheme::$options['blog_style'] == 'style4' ) {				
				if ( $layout_4 == 'right-sidebar' || $layout_4 == 'left-sidebar' ) {
					get_template_part( 'template-parts/content-4-masonry-sidebar', get_post_format() );
				} else {
					get_template_part( 'template-parts/content-4-masonry-nosidebar', get_post_format() );
				}
			} else if ( BartaTheme::$options['blog_style'] == 'style3' ) {
				get_template_part( 'template-parts/content-3', get_post_format() );
			} else if ( BartaTheme::$options['blog_style'] == 'style2' ) {
				if ( $layout_2 == 'right-sidebar' || $layout_2 == 'left-sidebar' ) {
					get_template_part( 'template-parts/content-2-sidebar', get_post_format() );
				} else {
					get_template_part( 'template-parts/content-2-nosidebar', get_post_format() );
				}
				
			} else if ( BartaTheme::$options['blog_style'] == 'style1' ) {
				get_template_part( 'template-parts/content-1', get_post_format() );
			} 
 
		endwhile;
		$html = ob_get_clean();
 
	} else {
		$more = false;
	}
	
	wp_send_json(compact('paged', 'html', 'more'));	
}

add_action('wp_ajax_barta_infinity_loadmore', 'barta_infinity_loading_ajax_handler'); // wp_ajax_{action}
add_action('wp_ajax_nopriv_barta_infinity_loadmore', 'barta_infinity_loading_ajax_handler'); // wp_ajax_nopriv_{action}

/*data filter*/
add_action('wp_ajax_br_cat_selected_cat', 'br_cat_selected_cat_fn' );
add_action('wp_ajax_nopriv_br_cat_selected_cat', 'br_cat_selected_cat_fn' );

function br_cat_selected_cat_fn() {
	
	/*if ( !wp_verify_nonce( $_POST['mynonce'], "ranna-nonce")) {
      exit("nonce not verified");
   } */
	
	$cat_ids = $_POST['catIDs'];
	
	$html = null;
		
	if($cat_ids){ ?>		
		
	<?php	
		$args = array(
			'cat' => $cat_ids,
			'post_status' => 'publish',
			//'orderby' => $post_sorting,
			//'order' => $post_ordering,
			'posts_per_page' => 10,
			
		);
	query_posts( $args );
	

	if( have_posts() ) {
			/*global $wp_query; 
			echo $dd = $wp_query->found_posts;*/
 
		ob_start();
		?>
		<div class="blockHalf2 row">
		<?php
		// run the loop
		$i = 1;
		global $wp_query; 
		$dd = $wp_query->found_posts;
		while( have_posts() ) { the_post(); 
			//echo get_the_ID(); echo ',';
		//the view ------------------------------------------
		?>
		
<?php
	$i = 1;
	//$temp = BartaTheme_Helper::wp_set_temp_query( $query );
	
?>
	<div class="col-xl-4 col-lg-4 col-md-4 col-sm-6 col-12">
		<div class="img-scale-animate">
			<a class="img-overlay-70" href="<?php the_permalink(); ?>">
				<?php
					if ( has_post_thumbnail() ){
						the_post_thumbnail( );
					}
				?>
			</a>
			<div class="mask-content-lg">								
				<div class="post-meta-light">
					<ul>
						<li><span><i class="fa fa-user" aria-hidden="true"></i></span><?php the_author_posts_link(); ?></li>			
					</ul>
				</div>
				<h2 class="title-medium-light">
					<a href="<?php the_permalink(); ?>"><?php echo esc_html( get_the_title() ); ?></a>
				</h2>
			</div>
		</div>
	</div>
<?php //BartaTheme_Helper::wp_reset_temp_query( $temp ); ?>

<?php
				
		 
		$i++; }  ?>
		<div class="mt20 col-sm-12 col--12 pagination-wrapper"><?php BartaTheme_Helper::pagination();?></div>
		<?php the_posts_pagination( array(
									'mid_size' => 2,
									'prev_text' => __( 'Back', 'twenty-minutes' ),
									'next_text' => __( 'Next', 'twenty-minutes' ),
									'screen_reader_text' => __( 'Posts navigation', 'twenty-minutes' )
								) );  ?>
		
</div>
<div class="loading"></div>
		<?php
		$html = ob_get_clean();
 
	}
		   
	wp_send_json( compact('html' , 'cat_ids' , 'dd'));
	
	
}

}

