<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

if ( !class_exists( 'BartaTheme_Helper' ) ) {
	
	class BartaTheme_Helper {

		public static function pagination() {
			
			if( is_singular() )
				return;

			global $wp_query;

			/** Stop execution if there's only 1 page */
			if( $wp_query->max_num_pages <= 1 )
				return;
			
			$paged = get_query_var( 'paged' ) ? absint( get_query_var( 'paged' ) ) : 1;
			$max   = intval( $wp_query->max_num_pages );

			/**	Add current page to the array */
			if ( $paged >= 1 )
				$links[] = $paged;

			/**	Add the pages around the current page to the array */
			if ( $paged >= 3 ) {
				$links[] = $paged - 1;
				$links[] = $paged - 2;
			}

			if ( ( $paged + 2 ) <= $max ) {
				$links[] = $paged + 2;
				$links[] = $paged + 1;
			}
			include BARTA_VIEW_DIR . 'pagination.php';
		}
		
		public static function load_more() {
			
			if( is_singular() )
				return;

			global $wp_query;

			/** Stop execution if there's only 1 page */
			if( $wp_query->max_num_pages <= 1 )
				return;
			
			printf ( '<div class="barta_loadmore btn-square-transparent">%s</div>', esc_html__( 'Load More', 'barta' ) );
		}
		
		public static function infinity() {
			if( is_singular() )
				return;
			global $wp_query;
			/** Stop execution if there's only 1 page */
			if( $wp_query->max_num_pages <= 1 )
				return;			
		}		

		public static function comments_callback( $comment, $args, $depth ){
			include BARTA_VIEW_DIR . 'comments-callback.php';
		}

		public static function hex2rgb($hex) {
			$hex = str_replace("#", "", $hex);
			if(strlen($hex) == 3) {
				$r = hexdec(substr($hex,0,1).substr($hex,0,1));
				$g = hexdec(substr($hex,1,1).substr($hex,1,1));
				$b = hexdec(substr($hex,2,1).substr($hex,2,1));
			} else {
				$r = hexdec(substr($hex,0,2));
				$g = hexdec(substr($hex,2,2));
				$b = hexdec(substr($hex,4,2));
			}
			$rgb = "$r, $g, $b";
			return $rgb;
		}

		public static function filter_social( $args ){
			return ( $args['url'] != '' );
		}
		
		public static function fonts_url(){
			$fonts_url = '';
			if ( 'off' !== _x( 'on', 'Google fonts - Open Sans and Roboto : on or off', 'barta' ) ) {
				$fonts_url = add_query_arg( 'family', urlencode( 'Roboto:400,500,700' ), "//fonts.googleapis.com/css" );
			}
			return $fonts_url;
		}

		//@rtl
		public static function maybe_rtl( $css ){
			if ( is_rtl() ) {
				return BARTA_AUTORTL_URL . $css;
			}
			else {
				return BARTA_CSS_URL . $css;
			}
		}
		
		public static function socials(){
			$barta_socials = array(
				'social_facebook' => array(
					'icon' => 'fa-facebook',
					'url'  => BartaTheme::$options['social_facebook'],
				),
				'social_twitter' => array(
					'icon' => 'fa-twitter',
					'url'  => BartaTheme::$options['social_twitter'],
				),
				'social_gplus' => array(
					'icon' => 'fa-google-plus',
					'url'  => BartaTheme::$options['social_gplus'],
				),
				'social_linkedin' => array(
					'icon' => 'fa-linkedin',
					'url'  => BartaTheme::$options['social_linkedin'],
				),
				'social_youtube' => array(
					'icon' => 'fa-youtube',
					'url'  => BartaTheme::$options['social_youtube'],
				),
				'social_pinterest' => array(
					'icon' => 'fa-pinterest',
					'url'  => BartaTheme::$options['social_pinterest'],
				),
				'social_instagram' => array(
					'icon' => 'fa-instagram',
					'url'  => BartaTheme::$options['social_instagram'],
				),
				'social_skype' => array(
					'icon' => 'fa-skype',
					'url'  => BartaTheme::$options['social_skype'],
				),
				'social_rss' => array(
					'icon' => 'fa-rss',
					'url'  => BartaTheme::$options['social_rss'],
				),
			);
			return array_filter( $barta_socials, array( 'BartaTheme_Helper' , 'filter_social' ) );
		}

		public static function nav_menu_args(){
			$barta_pagemenu = false;
			if ( ( is_single() || is_page() ) ) {
				$barta_menuid = get_post_meta( get_the_id(), 'barta_page_menu', true );
				if ( !empty( $barta_menuid ) && $barta_menuid != 'default' ) {
					$barta_pagemenu = $barta_menuid;
				}
			}
			if ( $barta_pagemenu ) {
				$nav_menu_args = array( 'menu' => $barta_pagemenu,'container' => 'nav' );
			}
			else {
				$nav_menu_args = array( 'theme_location' => 'primary','container' => 'nav' );
			}
			return $nav_menu_args;		
		}
				
		public static function has_footer(){
			if ( !BartaTheme::$options['footer_area']  ) {
				return false;
			}
			$footer_column = BartaTheme::$options['footer_column'];
			for ( $i = 1; $i <= $footer_column; $i++ ) {
				if ( is_active_sidebar( 'footer-'. $i ) ) {
					return true;
				}
			}
			return false;
		}
		
		public static function has_active_widget(){
			
			if ( BartaTheme::$sidebar ) {
				if ( is_active_sidebar( BartaTheme::$sidebar ) ) {
					
				}
			} else {
				if ( is_active_sidebar( 'sidebar' ) ) {
					
				}
			}			
			
			return false;
		}
		
		public static function get_img( $img ){
			$img = get_template_directory_uri() . '/assets/img/' . $img;
			return $img;
		}
		
		// query reset object
		public static function wp_set_temp_query( $query ) {
			global $wp_query;
			$temp = $wp_query;
			$wp_query = $query;
			return $temp;
		}

		public static function wp_reset_temp_query( $temp ) {
			global $wp_query;
			$wp_query = $temp;
			wp_reset_postdata();
		}
		
		public static function filter_content( $content ){
			// wp filters
			$content = wptexturize( $content );
			$content = convert_smilies( $content );
			$content = convert_chars( $content );
			$content = wpautop( $content );
			$content = shortcode_unautop( $content );

			// remove shortcodes
			$pattern= '/\[(.+?)\]/';
			$content = preg_replace( $pattern,'',$content );

			// remove tags
			$content = strip_tags( $content );

			return $content;
		}
		// get post function
		public static function get_current_post_content( $post = false ) {
			if ( !$post ) {
				$post = get_post();
			}
			$content = has_excerpt( $post->ID ) ? $post->post_excerpt : $post->post_content;
			$content = self::filter_content( $content );
			return $content;
		}

		private static function minified_css( $css ) {
			/* remove comments */
			$css = preg_replace( '!/\*[^*]*\*+([^/][^*]*\*+)*/!', '', $css );
			/* remove tabs, spaces, newlines, etc. */
			$css = str_replace( array( "\r\n", "\r", "\n", "\t", '  ', '    ', '    ' ), ' ', $css );
			return $css;
		}
		
		public static function custom_sidebar_fields(){
			$sidebar_fields = array();

			$sidebar_fields['sidebar'] = __( 'Sidebar', 'barta' );

			$sidebars = get_option( 'barta_custom_sidebars', array() );
			if ( $sidebars ) {
				foreach ( $sidebars as $sidebar ) {
					$sidebar_fields[$sidebar['id']] = $sidebar['name'];
				}
			}

			return $sidebar_fields;
		}
			
		public static function dynamic_internal_style(){
			ob_start();
			include BARTA_INC_DIR . 'variable-style.php';
			include BARTA_INC_DIR . 'variable-style-elementor.php';
			$dynamic_css  = ob_get_clean();
			$dynamic_css  = self::minified_css( $dynamic_css );
			wp_register_style( 'barta-dynamic', false );
			wp_enqueue_style( 'barta-dynamic' );
			wp_add_inline_style( 'barta-dynamic', $dynamic_css );			
		}
	}
}