<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

$barta_socials = BartaTheme_Helper::socials();
$barta_light_logo = empty( BartaTheme::$options['logo_light']['url'] ) ? BARTA_IMG_URL . 'logo-light.png' : BartaTheme::$options['logo_light']['url'];
?>
<div id="tophead" class="header-top-bar align-items-center">
	<div class="container">
		<div class="row">
			<div class="col-sm-8">
				<?php if ( !empty( BartaTheme::$options['banner_info_date'] ) || !empty( BartaTheme::$options['banner_info_update'] ) ) { ?>
				<ul class="news-info-list">
					<?php if ( !empty( BartaTheme::$options['banner_info_date'] )) { ?>
					<li><i class="fa fa-calendar" aria-hidden="true"></i><span id="current_date"><?php echo date_i18n( get_option('date_format') ); ?></span></li>
					<?php } ?>
					<?php if ( !empty( BartaTheme::$options['banner_info_update'] )) { ?>
					<li><i class="fa fa-clock-o" aria-hidden="true"></i><?php esc_html_e ( 'Last Update' , 'barta' ); ?> <?php barta_last_update(); ?></li>
					<?php } ?>
					<?php if ( !empty( BartaTheme::$options['city'] )) { ?>
					<li><i class="fa fa-map" aria-hidden="true"></i><?php echo esc_html ( BartaTheme::$options['city'] ) ; ?></li>
					<?php } ?>
				</ul>
				<?php } ?>
			</div>
			<div class="col-sm-4 tophead-right">
				<?php if ( $barta_socials ): ?>
					<ul class="tophead-social">
						<?php foreach ( $barta_socials as $barta_social ): ?>
							<li><a target="_blank" href="<?php echo esc_url( $barta_social['url'] );?>"><i class="fa <?php echo esc_attr( $barta_social['icon'] );?>"></i></a></li>
						<?php endforeach; ?>
					</ul>
				<?php endif; ?>
			</div>
			<div class="clear"></div>
		</div>
	</div>
</div>