<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Barta_Core;

use \WP_Query;
use radiustheme\Barta\BartaTheme;
use radiustheme\Barta\Helper;

$prefix      = BARTA_CORE_THEME_PREFIX;
$cpt         = BARTA_CORE_CPT_PREFIX;
$thumb_size  = "{$prefix}-size3";

$args = array(
	'posts_per_page' => $data['number'],
	'cat'            => (int) $data['cat'],
	'orderby'        => $data['orderby'],
	'posts_per_page' => $data['itemlimit'],
);


switch ( $data['orderby'] ) {
	case 'title':
	case 'menu_order':
	$args['order'] = 'ASC';
	break;
}


$query = new WP_Query( $args );

$temp = Helper::wp_set_temp_query( $query );

$col_class = "col-lg-{$data['col_lg']} col-md-{$data['col_md']} col-sm-{$data['col_sm']} col-xs-{$data['col_xs']}";
?>
<div class="post-grid-1">
	<?php if ( $query->have_posts() ) :?>
		<?php while ( $query->have_posts() ) : $query->the_post();?>
			<?php
			$content = Helper::get_current_post_content();
			$content = wp_trim_words( $content, $data['count'] );
			$content = "<p>$content</p>";

			$comments_number = number_format_i18n( get_comments_number() );
			$comments_html   = $comments_number < 2 ? __( 'Comment' , 'barta-core' ) : __( 'Comments' , 'barta-core' );
			$comments_html  .= ': '. $comments_number;
			?>

			<div class="rtin-content-area">
				<div class="rtin-date-area"><span class="rtin-date"><?php echo the_time('d / F / Y'); ?></span></div>
				<h3 class="rtin-title"><a href="<?php the_permalink();?>"><?php the_title();?></a></h3>
			</div>

		<?php endwhile;?>
	<?php endif;?>
	<?php Helper::wp_reset_temp_query( $temp );?>
</div>