<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Barta_Core;

use BartaTheme;
use BartaTheme_Helper;

use \WP_Query;

$thumb_size1 = 'barta-size4';
$thumb_size2 = 'barta-size10';

if ( get_query_var('paged') ) {
	$paged = get_query_var('paged');
}
else if ( get_query_var('page') ) {
	$paged = get_query_var('page');
}
else {
	$paged = 1;
}

// build up the array
foreach ( $data['category_list'] as $cat ) {
	$cats[] = array(
		'cat_single_tab' => $cat['cat_single_tab'],
	);
}
?>
<div class="tab-default <?php echo esc_attr( $template ); ?> <?php echo esc_attr( $data['small_item_style'] ); ?>">
	<div class="mb-20-r rtin-tab-container">
	<?php if ( $data['has_sec_title'] == 'yes' ) { ?>
		<div class="topic-border color-cinnabar">
			<div class="mb-25p">
				<div class="rt-news-box-title-holder <?php echo esc_attr( $data['title_style'] ); ?>">
					<h2 class="el-rt-news-box-title <?php echo esc_attr( $data['title_style'] ); ?>"><?php echo esc_html( $data['title'] ); ?><span class="titleinner"></span></h2>
					<div class="barta-tab-cat" data-settings='<?php echo json_encode( $data ); ?>' data-template="<?php echo esc_attr( $template ); ?>">
						<ul>
							<?php
							if ( !empty( $cats ) ) {
							//category
								$count_cat=1;
								foreach ( $cats as $cat ) {
								if ( $cat['cat_single_tab'] != 0 ) {
							?>
							<li <?php if ( $count_cat==1 ) { ?>class="active"<?php } ?>><span data-tab-cat="<?php echo esc_attr( $cat['cat_single_tab'] ); ?>" data-post-num="<?php echo esc_attr( $data['number_of_post'] ); ?>" data-sorting="<?php echo esc_attr( $data['post_sorting'] ); ?>" data-ordering="<?php echo esc_attr( $data['post_ordering'] ); ?>" data-title-length="<?php echo esc_attr( $data['post_title_length'] ); ?>"><?php echo esc_attr( get_cat_name( $cat['cat_single_tab'] ) ); ?></span></li>
							<?php $count_cat++; } } ?>
							
							<li><div class="more-link" ><a href="<?php echo get_category_link( $cats[0]['cat_single_tab'] ); ?>"><?php esc_html_e( 'More' , 'barta-core'); ?><i class="fa fa-angle-right" aria-hidden="true"></i></a></div></li>
							
							<?php  } ?>
						</ul>						
					</div>
				</div>
			</div>
		</div>
	<?php } ?>

		<div class="rt-tab-news-holder">
			<?php
			if ( !empty ( $cats[0]['cat_single_tab'] ) ) {
				$category = $cats[0]['cat_single_tab'];			
			} else {
				$category = 1;
			}
			// number
			$number_of_post = $data['number_of_post'];
			$number_of_post_offset = $data['number_of_post_offset'];			
			$content_limit = $data['post_excerpt_length'];
			$p_ids = array();
			
			// build up the array
			foreach ( $data['posts_not_in'] as $p_idsn ) {
				$p_ids[] = $p_idsn['post_not_in'];
			}
						
			// sort
			$post_sorting = $data['post_sorting'];
			// order
			$post_ordering = $data['post_ordering'];
			// Title Limit
			$title_limit = $data['post_title_length'];
			//print_r($category);
			$args = array(
				'cat' => $category,
				//'cat' => $category,
				'post_status' => 'publish',
				'order' => $post_ordering,
				'posts_per_page' => $number_of_post,
				'paged'          => $paged,
				'offset' 	 	 => $number_of_post_offset,
				'post__not_in'   => $p_ids
			);
				
			if ( $post_sorting == 'view' ) {
				$args['orderby']  = 'meta_value_num';
				$args['meta_key'] = 'barta_views';
			} else {
				$args['orderby'] = $post_sorting;
			}
			$query = new WP_Query( $args ); ?>
			
			<div class="blockHalf2 row">
				<?php
					$i = 1;
					$temp = BartaTheme_Helper::wp_set_temp_query( $query );
					
					if ( $query->have_posts() ) { 
						while ( $query->have_posts() ) {
						$query->the_post();
						$excerpt = wp_trim_words(get_the_excerpt(), $content_limit, '');
						$news_title = wp_trim_words( get_the_title(), $title_limit, '' );
						$news_comment_num = number_format_i18n( get_comments_number() );
						if ( !empty( $data['post_date_format'] ) ) {
							if ( $data['post_date_format'] == 'global' ){
								$formatted_post_date = get_the_date(); 
							} else {
								$formatted_post_date = get_the_date( 'M d, Y' );
							}
						}
					?>
					<?php if ( $i == 1 ) { ?>
					<div class="col-md-6 col-sm-12">
						<div class="img-scale-animate">
							<a class="img-overlay-70" href="<?php the_permalink(); ?>">
							<?php if ( $data['show_post_thumb'] == 'yes' ) { ?>
								<?php
									if ( has_post_thumbnail() ){
										the_post_thumbnail( $thumb_size1, ['class' => 'img-fluid mb-10 width-100'] );
									} else {
										if ( $data['show_no_preview_img'] == 'yes') {
										
											if ( !empty( BartaTheme::$options['no_preview_image']['id'] ) ) {
												echo wp_get_attachment_image( BartaTheme::$options['no_preview_image']['id'], $thumb_size1 );
											} else {
												echo '<img class="wp-post-image" src="' . BartaTheme_Helper::get_img( 'noimage-700x1015.jpg' ) . '" alt="'.get_the_title().'">';
											}
										}
									}
								?>
							<?php } ?>
							</a>
							<?php if ( $data['cat_display'] == 'yes' ) { ?> 
							<div class="topic-box-top-lg"><?php echo barta_category_prepare(); ?></div>
							<?php } ?>
							<div class="mask-content-lg">
								<div class="post-meta-light">
									<ul>
										<?php if ( $data['post_author'] == 'yes') { ?>
											<li><span><i class="fa fa-user" aria-hidden="true"></i></span><?php the_author_posts_link(); ?></li>
										<?php } ?>
										<?php if ( $data['post_date'] == 'yes' ) { ?>
											<li><span><i class="fa fa-clock-o" aria-hidden="true"></i></span><?php echo $formatted_post_date; ?></li>
										<?php } ?>
										<?php if ( $data['post_comment'] == 'yes' ) { ?>
											<li><span><i class="fa fa-comment-o" aria-hidden="true"></i></span><a href="<?php echo get_comments_link( get_the_ID() ); ?>"> <?php echo esc_html( $news_comment_num );?></a></li>
										<?php } ?>
									</ul>
								</div>
								<h2 class="title-medium-light">
									<a href="<?php the_permalink(); ?>"><?php echo esc_html( $news_title ); ?></a>
								</h2>
							</div>
						</div>
					</div>
					<?php } ?>
					<?php if ( $i == 2 ) { ?>
					<div class="col-md-6 col-sm-12">
					<?php } ?>
						<?php if ( $i > 1 ) { ?>
						<div class="media mb-30 <?php echo esc_attr( $data['small_item_style'] ); ?> ">
							<?php if ( $data['show_post_thumb'] == 'yes' ) { ?>
							<div class="image-left">
								<a class="img-opacity-hover" href="<?php the_permalink(); ?>">			
								<?php
									if ( has_post_thumbnail() ){
										the_post_thumbnail( $thumb_size2, ['class' => 'img-fluid mb-10 width-100'] );
									} else {
										if ( $data['show_no_preview_img'] == 'yes') {
										
											if ( !empty( BartaTheme::$options['no_preview_image']['id'] ) ) {
												echo wp_get_attachment_image( BartaTheme::$options['no_preview_image']['id'], $thumb_size2 );
											} else {
												echo '<img class="wp-post-image" src="' . BartaTheme_Helper::get_img( 'noimage-152x136.jpg' ) . '" alt="'.get_the_title().'">';
											}
										}
									}
								?>
								</a>
							</div>
							<?php } ?>
							<?php if ( $data['cat_display_small'] == 'yes' ) { ?><?php echo barta_category_prepare(); ?><?php } ?>
							<div class="media-body">
								<div class="post-meta-dark">
									<ul>
										<?php if ( $data['post_date'] == 'yes' ) { ?>
											<li><span><i class="fa fa-clock-o" aria-hidden="true"></i></span><?php echo $formatted_post_date; ?></li>
										<?php } ?>
									</ul>
								</div>
								<h3 class="title-medium-dark">
									<a href="<?php the_permalink(); ?>"><?php echo esc_html( $news_title ); ?></a>
								</h3>
							</div>
						</div>
						<?php } ?>
					<?php if ( $query->post_count == $i ) { ?>
					</div>
					<?php } ?>
				<?php $i++; } } ?>
				<?php BartaTheme_Helper::wp_reset_temp_query( $temp ); ?>
			</div> 
			<div class="loading"></div>
		</div>
	</div>
</div>