<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Barta_Core;
use BartaTheme;
use BartaTheme_Helper;

use \WP_Query;

$random_number = rand( 1 , 1999 );
?>
<div class="breaking-news-ticker" id="newsTicker<?php echo esc_attr( $random_number ); ?>">
	<div class="bn-label ticker-title"><?php echo esc_html( $data['title'] ); ?><div class="boltu-right"></div></div>
	<div class="bn-news">
		<ul>
		<?php
			$number_of_post = $data['number_of_post'];
			$post_sorting = $data['post_sorting'];
			$post_ordering = $data['post_ordering'];
			$selectpostshow = $data['selectpostshow'];			
			$control = $data['tcker_control'];
			
			$no_duplicate_post = array();	
			
			$a = $data['category_list'];
			
			if ( 'categorypost' == $selectpostshow ) {
			
				foreach ( $data['category_list'] as $cat ) { $cats[] = array( 'cat_multi_grid' => $cat['cat_multi_grid'] ); }				
				
				foreach ( $cats as $category ) {
				
				$args = array(
					'cat' => $category,
					'post_type' => 'post',
					'posts_per_page' => $number_of_post,
					'order' => $post_ordering,
					'post__not_in' => $no_duplicate_post
				);
					
			if ( $post_sorting == 'view' ) {
				$args['orderby']  = 'meta_value_num';
				$args['meta_key'] = 'barta_views';
			} else {
				$args['orderby'] = $post_sorting;
			}
			
			$the_query = new WP_Query( $args );
			
			while ( $the_query->have_posts() ) {

			$the_query->the_post();
			
			$no_duplicate_post[] = get_the_ID();
		?>
			<li><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></li>
		<?php } ?>
		<?php } 
		} else {			
				
			foreach ( $data['post_to_show'] as $selectedpost ) { $selectedpostids[] = array( 'selected_post_ids' => $selectedpost['selected_post_ids'] ); }
			
			//print_r($selectedpostids);
			if ( !empty( $selectedpostids ) ) {
			foreach ( $selectedpostids as $selectedpostid ) {
			
			$args = array(
				'p' =>  $selectedpostid['selected_post_ids'],
				'post_type' => 'post',
				'order' => $post_ordering,
			);
			
			if ( $post_sorting == 'view' ) {
				$args['orderby']  = 'meta_value_num';
				$args['meta_key'] = 'barta_views';
			} else {
				$args['orderby'] = $post_sorting;
			}
		
			$the_query = new WP_Query( $args );
			
			while ( $the_query->have_posts() ) {

			$the_query->the_post();		
			
			?>
			<li><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></li>		
			
		<?php }	} } } ?>
		</ul>
	</div>
	<?php if ( 'show' == $control ) { ?>
		<div class="bn-controls">
			<button><span class="bn-arrow bn-prev"></span></button>
			<button><span class="bn-action"></span></button>
			<button><span class="bn-arrow bn-next"></span></button>
		</div>
	<?php } ?>
</div>
<script>
jQuery(document).ready(function ($) {
	var scrollselector = '#newsTicker' + <?php echo esc_attr( $random_number ); ?>;
	$( scrollselector ).breakingNews({
		effect: <?php echo '"'. esc_html( $data['tcker_style'] ) .'"'; ?>,
		direction: <?php echo '"'. esc_html( $data['tcker_direction'] ) .'"'; ?>,
		height: <?php echo '"'. esc_html( $data['tcker_height'] ) .'"'; ?>,
		radius: <?php echo esc_html( $data['tcker_radius'] ); ?>,
		borderWidth:<?php echo esc_html( $data['tcker_border'] ); ?>,
		delayTimer: <?php echo esc_html( $data['time_delay'] ); ?>,
		scrollSpeed: <?php echo esc_html( $data['tcker_scrollspeed'] ); ?>,
		stopOnHover: <?php echo esc_html( $data['tcker_stoponhover'] ); ?>,
		position: <?php echo '"'. esc_html( $data['tcker_position'] ) .'"'; ?>,
	});
})
</script>