<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */
namespace radiustheme\Barta_Core;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Base;

if ( ! defined( 'ABSPATH' ) ) exit;

class Post_Slider extends Custom_Widget_Base {

	public function __construct( $data = [], $args = null ){
		$this->rt_name = __( 'RT News Slider', 'barta-core' );
		$this->rt_base = 'rt-post-slider';
		$this->rt_translate = array(
			'cols'  => array(
				'12' => __( '1 Col', 'barta-core' ),
				'6'  => __( '2 Col', 'barta-core' ),
				'4'  => __( '3 Col', 'barta-core' ),
				'3'  => __( '4 Col', 'barta-core' ),
				'2'  => __( '6 Col', 'barta-core' ),
			),
		);
		parent::__construct( $data, $args );
	}

	private function rt_load_scripts(){
		wp_enqueue_style( 'owl-carousel' );
		wp_enqueue_style( 'owl-theme-default' );
		wp_enqueue_script( 'owl-carousel' );
	}
	private function rt_slick_scripts(){
		wp_enqueue_style( 'slick' );
		wp_enqueue_script( 'slick' );
	}	
	
	private function rt_nivo_scripts(){
		wp_enqueue_style( 'nivo-slider' );
		wp_enqueue_script( 'nivo-slider' );
	}

	public function rt_fields(){
		$categories = get_categories();
		$category_dropdown = array( '0' => __( 'All Categories', 'barta-core' ) );

		foreach ( $categories as $category ) {
			$category_dropdown[$category->term_id] = $category->name;
		}

		$fields = array(
			/*News Box Style*/
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_general',
				'label'   => __( 'News Slider', 'barta-core' ),
			),
			/*Grid style option*/
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'layout_slider',
				'label'   => __( 'Slider Layout Style', 'barta-core' ),
				'options' => array(
					/*Grid Layout*/
					'slider1' => __( '01. Slider Style 1' , 'barta-core' ),
					'slider2' => __( '02. Slider Style 2' , 'barta-core' ),
					'slider3' => __( '03. Slider Style 3' , 'barta-core' ),
					'slider4' => __( '04. Slider Style 4' , 'barta-core' ),
				),
				'default' => 'slider1',
			),
			/*box title*/
			array(
				'label'			=> esc_html__( 'Show Title', 'barta-core' ),
				'type'  		=> Controls_Manager::SWITCHER,
				'id'			=> 'has_sec_title',
				'label_on'		=> esc_html__( 'Show', 'barta-core' ),
				'label_off' 	=> esc_html__( 'Hide', 'barta-core' ),
				'return_value'	=> 'yes',
				'default'		=> 'yes',				
			),
			array(
				'type'    => Controls_Manager::TEXTAREA,
				'id'      => 'title',
				'label'   => __( 'Title', 'barta-core' ),
				'default' => 'News',
				'condition' => array( 'has_sec_title' => array( 'yes' ) ),
			),			
			/*Title Style Option*/
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'title_style',
				'label'   => __( 'Title Style', 'barta-core' ),
				'options' => array(
					'style_1' => __( 'Style 1' , 'barta-core' ),
					'style_2' => __( 'style 2', 'barta-core' ),
				),
				'default' => 'style_2',
				'condition' => array( 'layout_slider' => array( 'slider1', 'slider3' ) ),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'title_color',
				'label'   => __( 'Title Color', 'barta-core' ),
				'default' => '#ffffff',
				'selectors' => array(
					'{{WRAPPER}} .el-rt-news-box-title' => 'color: {{VALUE}}',
				),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'title_bg_color',
				'label'   => __( 'Title Background Color', 'barta-core' ),
				'default' => '#111111',
				'selectors' => array( 
					'{{WRAPPER}} .el-rt-news-box-title.style_2' => 'background: {{VALUE}}',
					'{{WRAPPER}} .el-rt-news-box-title.style_2 .titleinner' => 'border-top-color: {{VALUE}}',
					'{{WRAPPER}} .rt-news-box-title-holder' => 'border-color: {{VALUE}}',
					'{{WRAPPER}} .el-rt-news-box-title.style_1' => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .el-rt-news-box-title.style_1 .titleinner' => 'border-top-color: {{VALUE}}',							
				),
			),
			/*from version 1.5*/			
			/*single or Multi category display option - switch*/
			array (
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'cat_num',
				'label'   => __( 'Single or Multiple category Select', 'barta-core' ),
				'options' => array(
					'multi' 	=> __( 'Multiple Category', 'barta-core' ),
					'single'	=> __( 'Single Category', 'barta-core' ),
				),
				'default' => 'single',				
				'condition' => array( 'layout_slider' => array( 'slider1', 'slider3' ) ),
			),
			/*category select( Box Single )*/
			array (
				'type'      => Controls_Manager::SELECT2,
				'id'        => 'cat_post_grid',
				'label'     => __( 'Categories', 'barta-core' ),
				'options'   => $category_dropdown,
				'default'   => '0',
				'multiple'  => false,
				'condition' => array( 'cat_num' => array( 'single' ), 'layout_slider' => array( 'slider1', 'slider3' )  ),
			),
			/*category select( Box Single )*/
			array (
				'type'      => Controls_Manager::SELECT2,
				'id'        => 'cat_post_grid_single',
				'label'     => __( 'Categories', 'barta-core' ),
				'options'   => $category_dropdown,
				'default'   => '0',
				'multiple'  => false,				
				'condition' => array( 'layout_slider' => array( 'slider2', 'slider4' ) ),
			),						
			/*category select( box Multi )*/
			array (
				'type'    => Controls_Manager::REPEATER,
				'id'      => 'category_list',
				'label'   => __( 'Add as many Categories as you want', 'barta-core' ),
				'fields'  => array(
					array(
						'type'    => Controls_Manager::SELECT2,
						'name'    => 'cat_multi_box',
						'label'   => __( 'Categories', 'barta-core' ),
						'options' => $category_dropdown,
						'multiple'=> false,
						'default' => '1',
					),
				),
				'condition' => array( 'cat_num' => array( 'multi' ) ),
			),			
			/*category display option - switch*/
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'cat_display',
				'label'       => __( 'Category Name Display', 'barta-core' ),
				'label_on'    => __( 'On', 'barta-core' ),
				'label_off'   => __( 'Off', 'barta-core' ),
				'default'     => 'yes',
			),
			/*Number of post - With dependancy*/
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'number_of_post',
				'label'   => __( 'Number of Post', 'barta-core' ),
				'default' => '6',
			),
			/*version 1.3*/
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'number_of_post_offset',
				'label'   => __( 'Number of Post Offset', 'barta-core' ),
				'default' => '0',
			),
			array(
				'type'    => Controls_Manager::REPEATER,
				'id'      => 'posts_not_in',
				'label'   => __( 'Enter Post ID that will not display', 'barta-core' ),
				'fields'  => array(
					array(
						'type'    => Controls_Manager::NUMBER,
						'name'    => 'post_not_in',
						'label'   => __( 'Post ID', 'barta-core' ),
						'default' => '0',
					),
				),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'item_title_color',
				'label'   => __( 'News Title Color', 'barta-core' ),
				'default' => '#111111',
				'selectors' => array( 
					'{{WRAPPER}} .default-slider h3.title-medium-dark a' => 'color: {{VALUE}}',
					'{{WRAPPER}} .rt-el-slider .rtin-content .title-medium-light a' => 'color: {{VALUE}}',
				),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'item_title_color_hover',
				'label'   => __( 'News Title Hover Color', 'barta-core' ),
				'default' => '#e53935',
				'selectors' => array( 
					'{{WRAPPER}} .default-slider h3.title-medium-dark a:hover' => 'color: {{VALUE}}',
					'{{WRAPPER}} .default-slider .post-meta-light ul li a:hover' => 'color: {{VALUE}}',
					'{{WRAPPER}} .rt-el-slider .post-meta-light ul li a:hover' => 'color: {{VALUE}}',
					'{{WRAPPER}} .rt-el-slider .rtin-content .title-medium-light a:hover' => 'color: {{VALUE}}',
				),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'item_date_color',
				'label'   => __( 'News Meta Color', 'barta-core' ),
				'default' => '#ffffff',
				'selectors' => array( 
					'{{WRAPPER}} .default-slider .post-meta-light ul li' => 'color: {{VALUE}}',
					'{{WRAPPER}} .default-slider .post-meta-light ul li a' => 'color: {{VALUE}}',
					'{{WRAPPER}} .rt-el-slider .post-meta-light ul li' => 'color: {{VALUE}}',
					'{{WRAPPER}} .rt-el-slider .post-meta-light ul li a' => 'color: {{VALUE}}',
				),
			),
			array(
				'mode' => 'section_end',
			),
			/*Common Post Display & Query Options*/
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_query',
				'label'   => __( 'Common Post Display & Query Options', 'barta-core' ),
			),
			/*Post Sorting*/
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'post_sorting',
				'label'   => __( 'Post Sorting', 'barta-core' ),
				'options' => array(
					'recent' 		=> __( 'Recent Post', 'barta-core' ),
					'rand' 			=> __( 'Random Post', 'barta-core' ),
					'modified' 		=> __( 'Last Modified Post', 'barta-core' ),
					'comment_count' => __( 'Most commented Post', 'barta-core' ),
					'view' 			=> __( 'Most viewed Post', 'barta-core' ),
				),
				'default' => 'recent',				
			),
			/*Post Order*/
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'post_ordering',
				'label'   => __( 'Post Ordering', 'barta-core' ),
				'options' => array(
					'DESC'	=> __( 'Desecending', 'barta-core' ),
					'ASC'	=> __( 'Ascending', 'barta-core' ),
				),
				'default' => 'DESC',
			),
			/*Post Title Length*/
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'post_title_length',
				'label'   => __( 'Post Title Length e.g: 10', 'barta-core' ),
				'default' => '5',
			),
			/*Post Excerpt Lenght*/
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'post_excerpt_length',
				'label'   => __( 'Post Excerpt Length e.g: 20', 'barta-core' ),
				'default' => '10',				
				'condition' => array( 'layout_slider' => array( 'slider2' ) ),
			),			
			array(				
				'id'  	=> 'hr',
				'type'	=> Controls_Manager::DIVIDER,				
				'style' => 'thick',
			),
			/*Display Post Date*/
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'post_date',
				'label'       => __( 'Display Post Date', 'barta-core' ),
				'label_on'    => __( 'On', 'barta-core' ),
				'label_off'   => __( 'Off', 'barta-core' ),
				'default'     => 'yes',
			),			
			/*Display Post Date Format*/
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'post_date_format',
				'label'   => __( 'Post Date Format', 'barta-core' ),
				'options' => array(
					'global' 		=> __( 'Wordpress Setting Format', 'barta-core' ),
					'custom' 		=> __( 'Customized', 'barta-core' ),
				),
				'default' => 'global',
			),
			/*Display Post Autor*/
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'post_author',
				'label'       => __( 'Display Author Name', 'barta-core' ),
				'label_on'    => __( 'On', 'barta-core' ),
				'label_off'   => __( 'Off', 'barta-core' ),
				'default'     => 'yes',
			),	
			/*Display Post Comment*/
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'post_comment',
				'label'       => __( 'Display Comment Number', 'barta-core' ),
				'label_on'    => __( 'On', 'barta-core' ),
				'label_off'   => __( 'Off', 'barta-core' ),
				'default'     => 'yes',
			),
			/*Hide Thumbnail*/			
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'show_post_thumb',
				'label'       => __( 'Display Post Thumbnail', 'barta-core' ),
				'label_on'    => __( 'On', 'barta-core' ),
				'label_off'   => __( 'Off', 'barta-core' ),
				'default'     => 'yes',
			),
			
			/*Show No Preview image*/			
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'show_no_preview_img',
				'label'       => __( 'Show No Preview Image', 'barta-core' ),
				'label_on'    => __( 'On', 'barta-core' ),
				'label_off'   => __( 'Off', 'barta-core' ),
				'default'     => 'yes',
			),			
			array(
				'mode' => 'section_end',
			),

			// Responsive Columns
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_responsive',
				'label'   => __( 'Number of Responsive Columns', 'barta-core' ),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'col_lg',
				'label'   => __( 'Desktops: > 1199px', 'barta-core' ),
				'options' => $this->rt_translate['cols'],
				'default' => '4',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'col_md',
				'label'   => __( 'Desktops: > 991px', 'barta-core' ),
				'options' => $this->rt_translate['cols'],
				'default' => '4',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'col_sm',
				'label'   => __( 'Tablets: > 767px', 'barta-core' ),
				'options' => $this->rt_translate['cols'],
				'default' => '6',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'col_xs',
				'label'   => __( 'Phones: < 768px', 'barta-core' ),
				'options' => $this->rt_translate['cols'],
				'default' => '6',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'col_mobile',
				'label'   => __( 'Small Phones: < 480px', 'barta-core' ),
				'options' => $this->rt_translate['cols'],
				'default' => '12',
			),
			array(
				'mode' => 'section_end',
			),

			// Slider options
			array(
				'mode'        => 'section_start',
				'id'          => 'sec_slider',
				'label'       => __( 'Slider Options', 'barta-core' ),
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'slider_nav',
				'label'       => __( 'Navigation Arrow', 'barta-core' ),
				'label_on'    => __( 'On', 'barta-core' ),
				'label_off'   => __( 'Off', 'barta-core' ),
				'default'     => '',
				'description' => __( 'Enable or disable navigation arrow. Default: Off', 'barta-core' ),
				'condition' => array( 'layout_slider' => array( 'slider1', 'slider2', 'slider3' ) ),
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'slider_dots',
				'label'       => __( 'Navigation Dots', 'barta-core' ),
				'label_on'    => __( 'On', 'barta-core' ),
				'label_off'   => __( 'Off', 'barta-core' ),
				'default'     => 'yes',
				'description' => __( 'Enable or disable navigation dots. Default: On', 'barta-core' ),
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'slider_autoplay',
				'label'       => __( 'Autoplay', 'barta-core' ),
				'label_on'    => __( 'On', 'barta-core' ),
				'label_off'   => __( 'Off', 'barta-core' ),
				'default'     => 'yes',
				'description' => __( 'Enable or disable autoplay. Default: On', 'barta-core' ),
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'slider_stop_on_hover',
				'label'       => __( 'Stop on Hover', 'barta-core' ),
				'label_on'    => __( 'On', 'barta-core' ),
				'label_off'   => __( 'Off', 'barta-core' ),
				'default'     => 'yes',
				'description' => __( 'Stop autoplay on mouse hover. Default: On', 'barta-core' ),
				'condition'   => array( 'slider_autoplay' => 'yes' ),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'slider_interval',
				'label'   => __( 'Autoplay Interval', 'barta-core' ),
				'options' => array(
					'5000' => __( '5 Seconds', 'barta-core' ),
					'4000' => __( '4 Seconds', 'barta-core' ),
					'3000' => __( '3 Seconds', 'barta-core' ),
					'2000' => __( '2 Seconds', 'barta-core' ),
					'1000' => __( '1 Second',  'barta-core' ),
				),
				'default' => '5000',
				'description' => __( 'Set any value for example 5 seconds to play it in every 5 seconds. Default: 5 Seconds', 'barta-core' ),
				'condition'   => array( 'slider_autoplay' => 'yes' ),
			),
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'slider_autoplay_speed',
				'label'   => __( 'Autoplay Slide Speed', 'barta-core' ),
				'default' => 200,
				'description' => __( 'Slide speed in milliseconds. Default: 200', 'barta-core' ),
				'condition'   => array( 'slider_autoplay' => 'yes' ),
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'slider_loop',
				'label'       => __( 'Loop', 'barta-core' ),
				'label_on'    => __( 'On', 'barta-core' ),
				'label_off'   => __( 'Off', 'barta-core' ),
				'default'     => 'yes',
				'description' => __( 'Loop to first item. Default: On', 'barta-core' ),
			),
			array(
				'mode' => 'section_end',
			),
		);
		return $fields;
	}

	protected function render() {
		$data = $this->get_settings();

		$owl_data = array( 
			'nav'                => $data['slider_nav'] == 'yes' ? true : false,
			'dots'               => $data['slider_dots'] == 'yes' ? true : false,
			'navText'            => array( "<i class='fa fa-angle-left'></i>", "<i class='fa fa-angle-right'></i>" ),
			'autoplay'           => $data['slider_autoplay'] == 'yes' ? true : false,
			'autoplayTimeout'    => $data['slider_interval'],
			'autoplaySpeed'      => $data['slider_autoplay_speed'],
			'autoplayHoverPause' => $data['slider_stop_on_hover'] == 'yes' ? true : false,
			'loop'               => $data['slider_loop'] == 'yes' ? true : false,
			'margin'             => 20,
			'responsive'         => array(
				'0'    => array( 'items' => 12 / $data['col_mobile'] ),
				'480'  => array( 'items' => 12 / $data['col_xs'] ),
				'768'  => array( 'items' => 12 / $data['col_sm'] ),
				'992'  => array( 'items' => 12 / $data['col_md'] ),
				'1200' => array( 'items' => 12 / $data['col_lg'] ),
			)
		);
		
		$data['owl_data'] = json_encode( $owl_data );
		
		switch ( $data['layout_slider'] ) {
			case 'slider4':			
			$this->rt_slick_scripts();
			$template = 'rt-news-slider-4';
			break;
			case 'slider3':			
			$this->rt_load_scripts();
			$template = 'rt-news-slider-3';
			break;
			case 'slider2':
			$this->rt_load_scripts();			
			$owl_data['responsive'] = array(
				'0'    => array( 'items' => 1 )
				);
			$template = 'rt-news-slider-2';
			break;
			default:
			$this->rt_load_scripts();
			$template = 'rt-news-slider-1';
			break;
		}
		
		return $this->rt_template( $template, $data );
	}
}