<?php if (!defined( 'ABSPATH' )) exit;

if( !class_exists('Moore_Cmb2_Customize') ){
    
    class Moore_Cmb2_Customize {

        public function __construct() {

            add_action( 'cmb2_init', array( $this, 'ova_moore_cmb2_customize' ) );
            
        }

        public function ova_moore_cmb2_customize( $atts ){

            // Start with an underscore to hide fields from custom fields list
            $prefix = 'ova_moore';
            
            $rooms_settings = new_cmb2_box( array(
                'id'            => 'ova_moore_room_settings',
                'title'         => esc_html__( 'Room settings', 'ova-framework' ),
                'object_types'  => array( 'ova_room'), // Post type
                'context'       => 'normal',
                'priority'      => 'high',
                'show_names'    => true,
                
            ) );

                $rooms_settings->add_field( array(
                    'name'       => esc_html__( 'Floor', 'ova-framework' ),
                    'id'         => $prefix . 'floor',
                    'type'    => 'text',
                    'attributes' => array(
                        'type' => 'number',
                    ),
                ) );

                $rooms_settings->add_field( array(
                    'name'       => esc_html__( 'BedRooms', 'ova-framework' ),
                    'id'         => $prefix . 'bedrooms',
                    'type'    => 'text',
                    'attributes' => array(
                        'type' => 'number',
                    ),
                ) );
               

                $rooms_settings->add_field( array(
                    'name'       => esc_html__( 'Area(M2)', 'ova-framework' ),
                    'id'         => $prefix . 'area',
                    'type'    => 'text',
                ) );

                $rooms_settings->add_field( array(
                    'name'       => esc_html__( 'Price(M)', 'ova-framework' ),
                    'id'         => $prefix . 'price',
                    'type'    => 'text',
                ) );

                $rooms_settings->add_field( array(
                    'name'       => esc_html__( 'Total($)', 'ova-framework' ),
                    'id'         => $prefix . 'total',
                    'type'    => 'text',
                ) );

                $rooms_settings->add_field( array(
                    'name'       => esc_html__( 'Date', 'ova-framework' ),
                    'id'         => $prefix . 'date',
                    'type'    => 'text_date',
                ) );

                $rooms_settings->add_field( array(
                    'name'    => esc_html__( 'Image Popup', 'ova-framework' ),
                    'desc'    => esc_html__( 'Upload Image Popup', 'ova-framework' ),
                    'id'      => $prefix . 'image_popup',
                    'type'    => 'file',
                    // Optional:
                    'options' => array(
                        'url' => false, // Hide the text input for the url
                    ),
                    'text'    => array(
                        'add_upload_file_text' => 'Add Image Popup' 
                    ),
                    // query_args are passed to wp.media's library query.
                    'query_args' => array(
                        // Only allow gif, jpg, or png images
                        'type' => array(
                            'image/gif',
                            'image/jpeg',
                            'image/png',
                        ),
                    ),
                    'preview_size' => 'medium', // Image size to use when previewing in the admin.
                ) );

                $rooms_settings->add_field( array(
                    'name' => esc_html__( 'URL Send Request', 'ova-framework' ),
                    'desc'    => esc_html__( 'URL Send Request Button', 'ova-framework' ),
                    'id'   =>  $prefix . 'url_send_request',
                    'type' => 'text_url',
                    // 'protocols' => array( 'http', 'https', 'ftp', 'ftps', 'mailto', 'news', 'irc', 'gopher', 'nntp', 'feed', 'telnet' ), // Array of allowed protocols
                ) );

                $rooms_settings->add_field( array(
                    'name'    => esc_html__( 'File Layout', 'ova-framework' ),
                    'desc'    => esc_html__('Upload File For Download Layout','ova-framework'),
                    'id'      =>  $prefix . 'file_layout',
                    'type'    => 'file',
                    // Optional:
                    'options' => array(
                        'url' => false, // Hide the text input for the url
                    ),
                    'text'    => array(
                        'add_upload_file_text' => 'Add File' 
                    ),
                    // query_args are passed to wp.media's library query.
                    'query_args' => array(
                        'type' => 'application/pdf', // Make library only display PDFs.
                        // Or only allow gif, jpg, or png images
                        // 'type' => array(
                        //     'image/gif',
                        //     'image/jpeg',
                        //     'image/png',
                        // ),
                    ),
                    'preview_size' => 'medium', // Image size to use when previewing in the admin.
                ) );


                $group_field_id = $rooms_settings->add_field( array(
                    'id'          => 'wiki_test_repeat_group',
                    'type'        => 'group',
                    'name'       => esc_html__( 'Utilities', 'ova-framework' ),
                    // 'repeatable'  => false, // use false if you want non-repeatable group
                    'options'     => array(
                        // 'group_title'       => __( 'Entry {#}', 'cmb2' ), // since version 1.1.4, {#} gets replaced by row number
                        'add_button'        => __( 'Add Another Entry', 'cmb2' ),
                        'remove_button'     => __( 'Remove Entry', 'cmb2' ),
                        'sortable'          => true,
                        // 'closed'         => true, // true to have the groups closed by default
                        // 'remove_confirm' => esc_html__( 'Are you sure you want to remove?', 'cmb2' ), // Performs confirmation before removing group.
                    ),
                ) );


                $rooms_settings->add_group_field( $group_field_id, array(
                    'name'      => esc_html__( 'Icon Class', 'ova-framework' ),
                    'id'   => 'social',
                    'type' => 'text',
                    // 'repeatable' => true, // Repeatable fields are supported w/in repeatable groups (for most types)
                ) );
            
        }

        

    }
}

return new Moore_Cmb2_Customize();

