<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Barta_Core;

use BartaTheme;
use BartaTheme_Helper;
use \WP_Query;

$thumb_size = 'barta-size5';

if ( get_query_var('paged') ) {
	$paged = get_query_var('paged');
}
else if ( get_query_var('page') ) {
	$paged = get_query_var('page');
}
else {
	$paged = 1;
}
?>
<div class="grid-default row <?php echo esc_attr( $data['layout_space'] ); ?> <?php echo $template; ?>">
	<?php if ( $data['has_sec_title'] == 'yes' ) { ?>
		<div class="col-12 mb-25p">
			<div class="rt-news-box-title-holder <?php echo esc_attr( $data['title_style'] ); ?>">
			<h2 class="el-rt-news-box-title <?php echo esc_attr( $data['title_style'] ); ?>"><?php echo esc_html( $data['title'] ); ?><span class="titleinner"></span></h2>
			</div>
		</div>
	<?php } ?>
	<?php
	$number_of_post = $data['number_of_post'];
	$number_of_post_offset = $data['number_of_post_offset'];
	$p_ids = array();
	
	// build up the array
	foreach ( $data['posts_not_in'] as $p_idsn ) {
		$p_ids[] = $p_idsn['post_not_in'];
	}
	// sort
	$post_sorting = $data['post_sorting'];
	// order
	$post_ordering = $data['post_ordering'];
	// Title Limit
	$title_limit = $data['post_title_length'];
	// content limit
	$content_limit = $data['post_excerpt_length'];
			
	$i = 1;
	
if ( $data['cat_num'] == 'multi' ) {
	// build up the array
	foreach ( $data['category_list'] as $cat ) { $cats[] = array( 'cat_multi_grid' => $cat['cat_multi_grid'], ); }
	
	if ( !empty( $cats ) ) {
	//category
	$category_number = count( $cats );
		foreach ( $cats as $cat ) {
		if ( $cat['cat_multi_grid'] != 0 ) {
		$args = array(
			'cat' => $cat['cat_multi_grid'],
			'order' => $post_ordering,
			'posts_per_page' => 1,
			'offset' 	 	 => $number_of_post_offset,
			'post__not_in'   => $p_ids
		);
		
		if ( $post_sorting == 'view' ) {
			$args['orderby']  = 'meta_value_num';
			$args['meta_key'] = 'barta_views';
		} else {
			$args['orderby'] = $post_sorting;
		}		
		$query = new WP_Query( $args );
		
		$temp = BartaTheme_Helper::wp_set_temp_query( $query );

		if ( $query->have_posts() ) {
			while ( $query->have_posts() ) {
			$query->the_post();
			$excerpt = wp_trim_words(get_the_excerpt(), $content_limit, '');
			$news_title = wp_trim_words( get_the_title(), $title_limit, '' );
			$news_comment_num = number_format_i18n( get_comments_number() );
			if ( !empty( $data['post_date_format'] ) ) {
				if ( $data['post_date_format'] == 'global' ){
					$formatted_post_date = get_the_date(); 
				} else {
					$formatted_post_date = get_the_date( 'M d, Y' );
				}
			}
	?>
	<div class="col-lg-3 col-md-6 col-sm-12 col-12">
		<div class="grid-item-8">
			<?php if ( $data['show_post_thumb'] == 'yes' ) { ?>
			<div class="news-grid-img">
				<a href="<?php the_permalink(); ?>" class="img-opacity-hover">			
					<?php
						if ( has_post_thumbnail() ){
							the_post_thumbnail( $thumb_size, ['class' => 'img-fluid mb-10 width-100'] );
						} else {
							if ( $data['show_no_preview_img'] == 'yes') {
							
								if ( !empty( BartaTheme::$options['no_preview_image']['id'] ) ) {
									echo wp_get_attachment_image( BartaTheme::$options['no_preview_image']['id'], $thumb_size );
								} else {
									echo '<img class="wp-post-image" src="' . BartaTheme_Helper::get_img( 'noimage-555x370.jpg' ) . '" alt="'.get_the_title().'">';
								}
							}
						}
					?>
				</a>
				<?php if ( $data['cat_display'] == 'yes' ) { echo barta_sel_category_prepare( $cat['cat_multi_grid'] ); } ?>
			</div>
			<?php } ?>
				<div class="post-meta-dark">
					<ul>
						<?php if ( $data['post_author'] == 'yes') { ?>
							<li><span><i class="fa fa-user" aria-hidden="true"></i></span><?php the_author_posts_link(); ?></li>
						<?php } ?>
						<?php if ( $data['post_date'] == 'yes' ) { ?>
							<li><span><i class="fa fa-clock-o" aria-hidden="true"></i></span><?php echo $formatted_post_date; ?></li>
						<?php } ?>
						<?php if ( $data['post_comment'] == 'yes' ) { ?>
							<li><span><i class="fa fa-comment-o" aria-hidden="true"></i></span><a href="<?php echo get_comments_link( get_the_ID() ); ?>"> <?php echo esc_html( $news_comment_num );?></a></li>
						<?php } ?>
					</ul>
				</div>
			<h3 class="post-cat-title">
				<a href="<?php the_permalink(); ?>"><?php echo esc_html( $news_title ); ?></a>
			</h3>
		</div>
	</div>
	<?php } ?>
		<?php if ( $data['pagination_display'] == 'yes' ) { ?>
			<div class="mt20 col-sm-12 col-xs-12 pagination-wrapper"><?php BartaTheme_Helper::pagination(); ?></div>
		<?php } ?>
	<?php } else { ?>
	<div class="col-lg-12 col-sm-12 col-12"><?php esc_html_e( 'No Post/News Found', 'barta-core' ); ?></div>
		<?php } 
		BartaTheme_Helper::wp_reset_temp_query( $temp );
		}
}  }  }	else {
		// number
		$number_of_post = $data['number_of_post'];
		$number_of_post_offset = $data['number_of_post_offset'];
		$p_ids = array();
		
		// build up the array
		foreach ( $data['posts_not_in'] as $p_idsn ) {
			$p_ids[] = $p_idsn['post_not_in'];
		}
		$cat_single_grid = $data['cat_single_grid'];
		
		$args2 = array(
			'cat' => $cat_single_grid,
			'post_status' => 'publish',
			'order' => $post_ordering,
			'posts_per_page' => $number_of_post,
			'paged'          => $paged,
			'offset' 	 	 => $number_of_post_offset,
			'post__not_in'   => $p_ids
		);
		
		if ( $post_sorting == 'view' ) {		
			$args['orderby']  = 'meta_value_num';
			$args['meta_key'] = 'barta_views';
		} else {
			$args['orderby'] = $post_sorting;
		}
		
		$query2 = new WP_Query( $args2 );
		
		$temp2 = BartaTheme_Helper::wp_set_temp_query( $query2 );
		
		if ( $query2->have_posts() ) {	
			while ( $query2->have_posts() ) {
			$query2->the_post();
			$excerpt = wp_trim_words(get_the_excerpt(), $content_limit, '');
			$news_title = wp_trim_words(get_the_title(), $title_limit, '');
			$news_comment_num = number_format_i18n( get_comments_number() );
			if ( !empty( $data['post_date_format'] ) ) {
				if ( $data['post_date_format'] == 'global' ){
					$formatted_post_date = get_the_date(); 
				} else {
					$formatted_post_date = get_the_date( 'M d, Y' );
				}
			}
	?>
		<div class="col-lg-3 col-md-6 col-sm-12 col-12">
			<div class="grid-item-8">
				<?php if ( $data['show_post_thumb'] == 'yes' ) { ?>
				<div class="news-grid-img">
					<a href="<?php the_permalink(); ?>" class="img-opacity-hover">			
						<?php
							if ( has_post_thumbnail() ){
								the_post_thumbnail( $thumb_size, ['class' => 'img-fluid mb-10 width-100'] );
							} else {
								if ( $data['show_no_preview_img'] == 'yes') {
								
									if ( !empty( BartaTheme::$options['no_preview_image']['id'] ) ) {
										echo wp_get_attachment_image( BartaTheme::$options['no_preview_image']['id'], $thumb_size );
									} else {
										echo '<img class="wp-post-image" src="' . BartaTheme_Helper::get_img( 'noimage-555x370.jpg' ) . '" alt="'.get_the_title().'">';
									}
								}
							}
						?>
					</a>
					<?php if ( $data['cat_display'] == 'yes' ) { echo barta_category_prepare(); } ?>
				</div>
				<?php } ?>
					<div class="post-meta-dark">
						<ul>
							<?php if ( $data['post_author'] == 'yes') { ?>
								<li><span><i class="fa fa-user" aria-hidden="true"></i></span><?php the_author_posts_link(); ?></li>
							<?php } ?>
							<?php if ( $data['post_date'] == 'yes' ) { ?>
								<li><span><i class="fa fa-clock-o" aria-hidden="true"></i></span><?php echo $formatted_post_date; ?></li>
							<?php } ?>
							<?php if ( $data['post_comment'] == 'yes' ) { ?>
								<li><span><i class="fa fa-comment-o" aria-hidden="true"></i></span><a href="<?php echo get_comments_link( get_the_ID() ); ?>"> <?php echo esc_html( $news_comment_num );?></a></li>
							<?php } ?>
						</ul>
					</div>
				<h3 class="post-cat-title">
					<a href="<?php the_permalink(); ?>"><?php echo esc_html( $news_title ); ?></a>
				</h3>
			</div>
		</div>
	<?php } ?>
		<?php if ( $data['pagination_display'] == 'yes' ) { ?>
			<div class="mt20 col-sm-12 col-xs-12 pagination-wrapper"><?php BartaTheme_Helper::pagination(); ?></div>
		<?php } ?>
	<?php } else { ?>
	<div class="col-lg-12 col-sm-12 col-12"><?php esc_html_e( 'No Post/News Found', 'barta-core' ); ?></div>
	<?php } BartaTheme_Helper::wp_reset_temp_query( $temp2 ); } ?>
</div>