<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Barta_Core;

use Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) exit;

class Counter extends Custom_Widget_Base {

	public function __construct( $data = [], $args = null ){
		$this->rt_name = __( 'Counter', 'barta-core' );
		$this->rt_base = 'rt-counter';
		parent::__construct( $data, $args );
	}

	private function rt_load_scripts(){
		wp_enqueue_script( 'waypoints' );
		wp_enqueue_script( 'counterup' );
	}

	public function rt_fields(){
		$fields = array(
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_general',
				'label'   => __( 'General', 'barta-core' ),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'theme',
				'label'   => __( 'Theme', 'barta-core' ),
				'options' => array(
					'light' => __( 'Light Background', 'barta-core' ),
					'dark'  => __( 'Dark Background', 'barta-core' ),
					'custom'  => __( 'Custom Layout', 'barta-core' ),
				),
				'default' => 'light',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'icontype',
				'label'   => __( 'Icon Type', 'barta-core' ),
				'options' => array(
					'icon'  => __( 'Icon', 'barta-core' ),
					'image' => __( 'Custom Image', 'barta-core' ),
				),
				'default' => 'icon',
			),
			array(
				'type'    => Controls_Manager::ICON,
				'id'      => 'icon',
				'label'   => __( 'Icon', 'barta-core' ),
				'default' => 'fa fa-handshake-o',
				'condition'   => array( 'icontype' => array( 'icon' ) ),
			),
			array(
				'type'    => Controls_Manager::MEDIA,
				'id'      => 'image',
				'label'   => __( 'Image', 'barta-core' ),
				'condition'   => array( 'icontype' => array( 'image' ) ),
				'description' => __( 'Recommended image size is 60x70 px', 'barta-core' ),
			),
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'number',
				'label'   => __( 'Counter Number', 'barta-core' ),
				'default' => 5000,
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'number_color',
				'label'   => __( 'Counter Color', 'barta-core' ),
				'default' => '',
				'condition' => array( 'theme' => array( 'custom' ) ),
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'suffix',
				'label'   => __( 'Counter Suffix', 'barta-core' ),
				'description' => __( 'Put any text or symbol after Counter Number eg. +', 'barta-core' ),
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'title',
				'label'   => __( 'Title', 'barta-core' ),
				'default' => __( 'Satisfied Customers', 'barta-core' ),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'title_color',
				'label'   => __( 'Title Color', 'barta-core' ),
				'default' => '',
				'condition' => array( 'theme' => array( 'custom' ) ),
			),
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'speed',
				'label'   => __( 'Animation Speed', 'barta-core' ),
				'default' => 5000,
				'description' => __( 'The total duration of the count animation in milisecond eg. 5000', 'barta-core' ),
			),
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'steps',
				'label'   => __( 'Animation Steps', 'barta-core' ),
				'default' => 10,
				'description' => __( 'Counter steps eg. 10', 'barta-core' ),
			),
			array(
				'mode' => 'section_end',
			),
		);
		return $fields;
	}

	protected function render() {
		$data = $this->get_settings();
		$this->rt_load_scripts();
		
		switch ( $data['theme'] ) {
			case 'custom':
			$template = 'counter-custom';
			break;
			default:
			$template = 'counter';
			break;
		}


		return $this->rt_template( $template, $data );
	}
}