<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

add_action( 'template_redirect', 'barta_template_vars' );
if( !function_exists( 'barta_template_vars' ) ) {
    function barta_template_vars() {
        // Single Pages
        if( is_single() || is_page() ) {
            $post_type = get_post_type();
            $post_id   = get_the_id();
            switch( $post_type ) {
                case 'page':
                $prefix = 'page';
                break;
                case 'post':
                $prefix = 'single_post';
                break;
                case 'product':
                $prefix = 'product';
                break;
                default:
                $prefix = 'single_post';
                break;
            }

            $layout         	= get_post_meta( $post_id, 'barta_layout', true );
			$sidebar         	= get_post_meta( $post_id, 'barta_sidebar', true );
            $tr_header      	= get_post_meta( $post_id, 'barta_tr_header', true );
            $top_bar        	= get_post_meta( $post_id, 'barta_top_bar', true );
            $top_bar_style  	= get_post_meta( $post_id, 'barta_top_bar_style', true );
            $header_style   	= get_post_meta( $post_id, 'barta_header', true );
            $padding_top    	= get_post_meta( $post_id, 'barta_top_padding', true );
            $padding_bottom 	= get_post_meta( $post_id, 'barta_bottom_padding', true );
            $has_banner     	= get_post_meta( $post_id, 'barta_banner', true );
            $has_banner_ticker  = get_post_meta( $post_id, 'barta_banner_ticker', true );
            $has_banner_info    = get_post_meta( $post_id, 'barta_banner_info', true );
            $has_breadcrumb 	= get_post_meta( $post_id, 'barta_breadcrumb', true );
            $bgtype         	= get_post_meta( $post_id, 'barta_banner_type', true );
            $bgcolor        	= get_post_meta( $post_id, 'barta_banner_bgcolor', true );
            $bgimg          	= get_post_meta( $post_id, 'barta_banner_bgimg', true );
            $pagebgcolor        = get_post_meta( $post_id, 'barta_page_bgcolor', true );
            $pagebgimg          = get_post_meta( $post_id, 'barta_page_bgimg', true );

            BartaTheme::$layout = ( empty( $layout ) || $layout == 'default' ) ? BartaTheme::$options[$prefix . '_layout'] : $layout;

			BartaTheme::$sidebar = ( empty( $sidebar ) || $sidebar == 'default' ) ? BartaTheme::$options[$prefix . '_sidebar'] : $sidebar;

			BartaTheme::$tr_header = ( empty( $tr_header ) || $tr_header == 'default' ) ? BartaTheme::$options['tr_header'] : $tr_header;

            BartaTheme::$top_bar = ( empty( $top_bar ) || $top_bar == 'default' ) ? BartaTheme::$options['top_bar'] : $top_bar;

            BartaTheme::$top_bar_style = ( empty( $top_bar_style ) || $top_bar_style == 'default' ) ? BartaTheme::$options['top_bar_style'] : $top_bar_style;

            BartaTheme::$header_style = ( empty( $header_style ) || $header_style == 'default' ) ? BartaTheme::$options['header_style'] : $header_style;

            $padding_top = ( empty( $padding_top ) || $padding_top == 'default' ) ? BartaTheme::$options[$prefix . '_padding_top'] : $padding_top;
            BartaTheme::$padding_top = (int) $padding_top;

            $padding_bottom = ( empty( $padding_bottom ) || $padding_bottom == 'default' ) ? BartaTheme::$options[$prefix . '_padding_bottom'] : $padding_bottom;
            BartaTheme::$padding_bottom = (int) $padding_bottom;

            BartaTheme::$has_banner_ticker = ( empty( $has_banner_ticker ) || $has_banner_ticker == 'default' ) ? BartaTheme::$options[$prefix . '_banner_ticker'] : $has_banner_ticker;

            BartaTheme::$has_banner_info = ( empty( $has_banner_info ) || $has_banner_info == 'default' ) ? BartaTheme::$options[$prefix . '_banner_info'] : $has_banner_info;

            BartaTheme::$has_banner = ( empty( $has_banner ) || $has_banner == 'default' ) ? BartaTheme::$options[$prefix . '_banner'] : $has_banner;

            BartaTheme::$has_breadcrumb = ( empty( $has_breadcrumb ) || $has_breadcrumb == 'default' ) ? BartaTheme::$options[$prefix . '_breadcrumb'] : $has_breadcrumb;

            BartaTheme::$bgtype = ( empty( $bgtype ) || $bgtype == 'default' ) ? BartaTheme::$options[$prefix . '_bgtype'] : $bgtype;

            BartaTheme::$bgcolor = empty( $bgcolor ) ? BartaTheme::$options[$prefix . '_bgcolor'] : $bgcolor;

            if( !empty( $bgimg ) ) {
                $attch_url      = wp_get_attachment_image_src( $bgimg, 'full', true );
                BartaTheme::$bgimg = $attch_url[0];
            } elseif( !empty( BartaTheme::$options[$prefix . '_bgimg']['id'] ) ) {
                $attch_url      = wp_get_attachment_image_src( BartaTheme::$options[$prefix . '_bgimg']['id'], 'full', true );
                BartaTheme::$bgimg = $attch_url[0];
            } else {
                BartaTheme::$bgimg = BARTA_IMG_URL . 'banner.jpg';
            }

            BartaTheme::$pagebgcolor = empty( $pagebgcolor ) ? BartaTheme::$options[$prefix . '_page_bgcolor'] : $pagebgcolor;

            if( !empty( $pagebgimg ) ) {
                $attch_url      = wp_get_attachment_image_src( $pagebgimg, 'full', true );
                BartaTheme::$pagebgimg = $attch_url[0];
            } elseif( !empty( BartaTheme::$options[$prefix . '_bgimg']['id'] ) ) {
                $attch_url      = wp_get_attachment_image_src( BartaTheme::$options[$prefix . '_page_bgimg']['id'], 'full', true );
                BartaTheme::$pagebgimg = $attch_url[0];
            }
        }

        // Blog and Archive
        elseif( is_home() || is_archive() || is_search() || is_404() ) {
            if( is_search() ) {
                $prefix = 'search';
            } else if( is_404() ) {
                $prefix                                = 'error';
                BartaTheme::$options[$prefix . '_layout'] = 'full-width';
            } else if( function_exists( 'is_woocommerce' ) && is_woocommerce() ) {
                $prefix = 'shop';
            } else {
                $prefix = 'blog';
            }

            BartaTheme::$layout         	= BartaTheme::$options[$prefix . '_layout'];
            BartaTheme::$tr_header      	= BartaTheme::$options['tr_header'];
            BartaTheme::$top_bar        	= BartaTheme::$options['top_bar'];
            BartaTheme::$sidebar        	= BartaTheme::$options[$prefix . '_sidebar'];
            BartaTheme::$top_bar_style  	= BartaTheme::$options['top_bar_style'];
            BartaTheme::$header_style   	= BartaTheme::$options['header_style'];
            BartaTheme::$padding_top    	= BartaTheme::$options[$prefix . '_padding_top'];
            BartaTheme::$padding_bottom 	= BartaTheme::$options[$prefix . '_padding_bottom'];
            BartaTheme::$has_banner_ticker = BartaTheme::$options[$prefix . '_banner_ticker'];
            BartaTheme::$has_banner_info   = BartaTheme::$options[$prefix . '_banner_info'];
            BartaTheme::$has_banner     	= BartaTheme::$options[$prefix . '_banner'];
            BartaTheme::$has_breadcrumb 	= BartaTheme::$options[$prefix . '_breadcrumb'];
            BartaTheme::$bgtype         	= BartaTheme::$options[$prefix . '_bgtype'];
            BartaTheme::$bgcolor        	= BartaTheme::$options[$prefix . '_bgcolor'];

            if( !empty( BartaTheme::$options[$prefix . '_bgimg']['id'] ) ) {
                $attch_url      = wp_get_attachment_image_src( BartaTheme::$options[$prefix . '_bgimg']['id'], 'full', true );
                BartaTheme::$bgimg = $attch_url[0];
            } else {
                BartaTheme::$bgimg = BARTA_IMG_URL . 'banner.jpg';
            }

            BartaTheme::$pagebgcolor        	= BartaTheme::$options[$prefix . '_page_bgcolor'];

            if( !empty( BartaTheme::$options[$prefix . '_page_bgimg']['id'] ) ) {
                $attch_url      = wp_get_attachment_image_src( BartaTheme::$options[$prefix . '_page_bgimg']['id'], 'full', true );
                BartaTheme::$pagebgimg = $attch_url[0];
            }
        }
    }
}

// Add body class
add_filter( 'body_class', 'barta_body_classes' );
if( !function_exists( 'barta_body_classes' ) ) {
    function barta_body_classes( $classes ) {

        $classes[] = 'header-style-'. BartaTheme::$header_style;

        if ( BartaTheme::$top_bar == 1 || BartaTheme::$top_bar == 'on' ){
            $classes[] = 'has-topbar topbar-style-'. BartaTheme::$top_bar_style;
        }

        if ( BartaTheme::$tr_header == 1 || BartaTheme::$tr_header == 'on' ) { $classes[] = 'trheader'; }

        $classes[] = ( BartaTheme::$layout == 'full-width' ) ? 'no-sidebar' : 'has-sidebar';

		$classes[] = ( BartaTheme::$layout == 'left-sidebar' ) ? 'left-sidebar' : 'right-sidebar';

		$classes[] = ( BartaTheme::$options['scroll_indicator_enable'] == '1' ) ? 'scroll_indicator_on' : '';

        if( isset( $_COOKIE["shopview"] ) && $_COOKIE["shopview"] == 'list' ) {
            $classes[] = 'product-list-view';
        } else {
            $classes[] = 'product-grid-view';
        }
		$is_ad_active1 = get_post_meta( get_the_ID(), 'barta_header_top_ad', true );
		if ( !empty( $is_ad_active1 ) ) {
			$classes[] = 'header-top-banner';
		}
		if ( is_singular('post') ) {
			$classes[] =  ' post-detail-' . BartaTheme::$options['post_style'];
        }
        return $classes;
    }
}