<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

add_action('tgmpa_register', 'barta_register_required_plugins');
function barta_register_required_plugins()
{
    $plugins = array(
        // Bundled
        array(
            'name'         => 'Barta Core',
            'slug'         => 'barta-core',
            'source'       => 'barta-core.zip',
            'required'     =>  true,
            'external_url' => 'http://radiustheme.com',
            'version'      => '2.0.2'
        ),
        array(
            'name'         => 'RT Framework',
            'slug'         => 'rt-framework',
            'source'       => 'rt-framework.zip',
            'required'     =>  true,
            'external_url' => 'http://radiustheme.com',
            'version'      => '1.14'
        ),
        array(
            'name'         => 'RT Demo Importer',
            'slug'         => 'rt-demo-importer',
            'source'       => 'rt-demo-importer.zip',
            'required'     =>  true,
            'external_url' => 'http://radiustheme.com',
            'version'      => '4.3'
        ),
        array(
            'name'         => 'WP Seo Structured Data Schema Pro',
            'slug'         => 'wp-seo-structured-data-schema-pro',
            'source'       => 'wp-seo-structured-data-schema-pro.zip',
            'required'     =>  false,
            'external_url' => 'http://radiustheme.com',
            'version'      => '1.4.2'
        ),

        // Repository
        array(
            'name'     => 'Elementor Page Builder',
            'slug'     => 'elementor',
            'required' => true,
        ),
        array(
            'name'     => 'Redux Framework',
            'slug'     => 'redux-framework',
            'required' => true,
        ),
        array(
            'name'     => 'WooCommerce',
            'slug'     => 'woocommerce',
            'required' => false,
        ),
        array(
            'name'     => 'Contact Form 7',
            'slug'     => 'contact-form-7',
            'required' => false,
        ),
        array(
            'name'     => 'Social Counter',
            'slug'     => 'accesspress-social-counter',
            'required' => false,
        ),
        array(
            'name'     => 'MailChimp for WordPress',
            'slug'     => 'mailchimp-for-wp',
            'required' => false,
        ),
    );

    $config = array(
        'id'           => 'barta',             // Unique ID for hashing notices for multiple instances of TGMPA.
        'default_path' => BARTA_PLUGINS_DIR,   // Default absolute path to bundled plugins.
        'menu'         => 'barta-install-plugins', // Menu slug.
        'has_notices'  => true,                    // Show admin notices or not.
        'dismissable'  => true,                    // If false, a user cannot dismiss the nag message.
        'dismiss_msg'  => '',                      // If 'dismissable' is false, this message will be output at top of nag.
        'is_automatic' => false,                   // Automatically activate plugins after installation or not.
        'message'      => '',                      // Message to output right before the plugins table.
    );

    tgmpa($plugins, $config);
}
