<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

$primary_color   = BartaTheme::$options['primary_color']; // #e53935
$secondery_color = '#797979';
$primary_rgb     = BartaTheme_Helper::hex2rgb( $primary_color ); // 0, 33, 71
$secondary_rgb   = BartaTheme_Helper::hex2rgb( $secondery_color ); // 0, 33, 71

/*---------------------------------    
INDEX
===================================
#. VC: Button
#. VC: Section Title
#. VC: Owl Nav 1
#. VC: Owl Nav 2
#. VC: Owl Nav 3
#. VC: Owl Nav 4
#. VC: Testimonial Slider 1
#. VC: Testimonial Slider 2
#. VC: Team Slider
#. VC: About
#. VC: Opening Hour
#. VC: Text With Button
#. VC: Post
#. VC: Info Text
#. VC: Tab ( Restyling )
#. VC: Award Box
#. VC: CTA
#. VC: Law Grids
#. VC: Team Sliders
#. VC: Pricing Table 1
#. VC: Pricing Table 2
#. VC: Logo Showcase
#. VC: History Box
#. VC: Counter
#. VC: Service Grid
#. VC: Project
----------------------------------*/
/*-----------------------
#. VC: Button
------------------------*/
?>
.entry-content .light-button ,
.entry-content .light-button i,
.entry-content a.grid-fill-btn:hover,
.entry-content .rt-grid-fill-btn a.grid-fill-btn:hover,
.entry-content .rt-text-with-btn a.light-box:hover {
	color: <?php echo esc_html($primary_color); ?> !important;
}
.entry-content .light-button:hover,
.entry-content .light-button:hover i {
	background: <?php echo esc_html($primary_color); ?> !important;
	color: #ffffff !important;
	border: 2px solid <?php echo esc_html($primary_color); ?>;
}
.entry-content a.grid-fill-btn,
.entry-content .rt-grid-fill-btn a.grid-fill-btn,
.dark-button {
	border: 2px solid <?php echo esc_html($primary_color); ?>;
	background: <?php echo esc_html($primary_color); ?>;
}
.entry-content .rt-text-with-btn a.light-box {
    background: <?php echo esc_html($primary_color); ?>;
}
<?php
/*-----------------------
#. VC: Section Title
------------------------*/
?>
.rt-vc-title-1 h2::after,
.rt-vc-title h2:after ,
.section-title h2:after {
	background: <?php echo esc_html($primary_color); ?>;
}
<?php
/*-------------------------------------
#. VC: Owl Nav 1
---------------------------------------*/
?>
.rt-el-slider .nivo-controlNav .nivo-control.active {
  background-color: <?php echo esc_html($primary_color); ?>;
}
.rt-owl-nav-1 .owl-carousel .owl-nav .owl-prev ,
.rt-owl-nav-1 .owl-carousel .owl-nav .owl-next {
  border: 2px solid <?php echo esc_html($primary_color); ?>;
  color: <?php echo esc_html($primary_color); ?>;
}
.rt-owl-nav-1 .owl-carousel .owl-nav .owl-prev:hover ,
.rt-owl-nav-1 .owl-carousel .owl-nav .owl-next:hover {
  background-color: <?php echo esc_html($primary_color); ?>;
}
.rt-owl-nav-1 .owl-carousel .owl-dots .owl-dot span:hover span ,
.rt-owl-nav-1 .owl-carousel .owl-dots .owl-dot.active span {
  background: <?php echo esc_html($primary_color); ?>;
}
<?php
/*-------------------------------------
#. VC: Owl Nav 2
---------------------------------------*/
?>
/*for both option control*/
.rt-owl-nav-2.slider-nav-enabled .owl-carousel .owl-prev ,
.rt-owl-nav-2.slider-nav-enabled .owl-carousel .owl-next {
  color: <?php echo esc_html($primary_color); ?>;
  border: 2px solid <?php echo esc_html($primary_color); ?>;
}
.rt-owl-nav-2.slider-nav-enabled .owl-carousel .owl-prev:hover ,
.rt-owl-nav-2.slider-nav-enabled .owl-carousel .owl-next:hover {
  background-color: <?php echo esc_html($primary_color); ?>;
}
.rt-owl-nav-2.slider-dot-enabled .owl-carousel .owl-dot span:hover span ,
.rt-owl-nav-2.slider-dot-enabled .owl-carousel .owl-dot.active span {
  background: <?php echo esc_html($primary_color); ?>;
}
<?php
/*-------------------------------------
#. VC: Owl Nav 3
---------------------------------------*/
?>
.rt-owl-nav-3 .owl-custom-nav .owl-prev {
  color: <?php echo esc_html($primary_color); ?>;
  border: 2px solid <?php echo esc_html($primary_color); ?>;
}
.rt-owl-nav-3 .owl-custom-nav .owl-prev:hover ,
.rt-owl-nav-3 .owl-custom-nav .owl-next:hover {
  background-color: <?php echo esc_html($primary_color); ?>;
}
.rt-owl-nav-3 .owl-custom-nav .owl-next {
  color: <?php echo esc_html($primary_color); ?>;
  border: 2px solid <?php echo esc_html($primary_color); ?>;
}
.rt-owl-nav-3.slider-dot-enabled .owl-carousel .owl-dot span:hover span ,
.rt-owl-nav-3.slider-dot-enabled .owl-carousel .owl-dot.active span {
  background: <?php echo esc_html($primary_color); ?>;
}
.rt-project-slider-one .sub-title {
	color: <?php echo esc_html($primary_color); ?>;
}
.rt-project-slider-one .rtin-projects-box .our-projects-content-holder span {
	background: <?php echo esc_html($primary_color); ?>;
}
.rt-project-slider-one .rtin-projects-box .our-projects-img-holder:before {
    background: rgba(<?php echo esc_html($primary_rgb); ?>, 0.8);	
}
.rt-service-grid-4 .rtin-single-post .rtin-item-image:after {
    background-color: rgba(<?php echo esc_html($primary_rgb); ?>, 0.7);
}
.rt-project-slider-one .rtin-projects-box .our-projects-content-holder h3 a:hover,
.project-gallery1-area .sub-title {
	color: <?php echo esc_html($primary_color); ?>;
}
.rt-service-grid-4 .rtin-single-post:hover .rtin-item-info h3 a ,
.rt-service-grid-4 .rtin-single-post .rtin-item-image a.plus-icon:hover {
	color: <?php echo esc_html($primary_color); ?>;
}
<?php
/*-------------------------------------
#. VC: Testimonial Slider 1
---------------------------------------*/
?>
.rt-testimonial-slider-1 .rtin-single-client-area h3 a:hover ,
.rt-testimonial-slider-1 .rtin-single-client-area .picture ul li a i {
  color: <?php echo esc_html($primary_color); ?>;
}
<?php
/*-------------------------------------
#. VC: Testimonial Slider 2
---------------------------------------*/
?>
.rt-testimonial-slider-2 .rtin-single-testimonial .rtin-testi-content:before ,
.rt-testimonial-slider-2 .rtin-single-testimonial .rtin-testi-content:after {
  color: <?php echo esc_html($primary_color); ?>;
}
<?php
/*-------------------------------------
#. VC: Testimonial Slider 2
---------------------------------------*/
?>
.rt-testimonial-slider-2 .rtin-single-testimonial .rtin-testi-content:before ,
.rt-testimonial-slider-2 .rtin-single-testimonial .rtin-testi-content:after {
  color: <?php echo esc_html($primary_color); ?>;
}
.client-inner-area-right.rt-owl-nav-2.slider-dot-enabled .owl-carousel .owl-dots > .active span {
    background: <?php echo esc_html($primary_color); ?>;
    border: 2px solid <?php echo esc_html($primary_color); ?>;
}
.client-inner-area-right .client-box .media .image-holder img {
    border: 1px dashed <?php echo esc_html($primary_color); ?>;
}
.rt-testimonial-slider-6 .owl-item .tlp-tm-content-wrapper .item-content {
	background-color: rgba(<?php echo esc_html($primary_rgb); ?>, 0.8);
}
.rt-testimonial-slider-6 .ts-section-title::after {
	background: <?php echo esc_html($primary_color); ?>;
}
<?php
/*-------------------------------------
#. VC: Post
---------------------------------------*/
?>
<?php
/*-------------------------------------
#. VC: Info Text
---------------------------------------*/
?>
.rt-info-text .info-ghost-button a {
  border: 2px solid <?php echo esc_html($primary_color); ?>;
  color: <?php echo esc_html($primary_color); ?>;
}
.rt-info-text .info-ghost-button a:hover {
  background: <?php echo esc_html($primary_color); ?>;
  border: 2px solid <?php echo esc_html($primary_color); ?>;
}
.rt-info-text.layout1 i, 
.rt-info-text.layout2 i,
.rt-info-text.layout3 i {
  color: <?php echo esc_html($primary_color); ?>;
}
.rt-info-text.layout4 i ,
.rt-infobox-5 .rtin-single-info .rtin-info-item-icon ,
.rt-infobox-6 .rtin-info-icon ,
.rt-infobox-6:hover .rtin-info-content h3 ,
.rt-infobox-6:hover .rtin-info-content h3 a,
.rt-info-text-6 .service-box > a,
.rt-infobox-7 .rtin-single-info-item .rtin-single-info:hover .rtin-info-content h3 a ,
.rt-infobox-8 .media .media-left i ,
.rt-infobox-9 .media .media-left i ,
.rt-infobox-10 h3 a:hover ,
.rt-infobox-10:hover h2 a {
  color: <?php echo esc_html($primary_color); ?>;
}
.rt-infobox-8 .media .media-body h3:after ,
.rt-infobox-10 .rtin-info-icon a ,
.rt-infobox-10 h3 a:after {
  background: <?php echo esc_html($primary_color); ?>;
}
.rt-info-text-3 .service-box:hover .service-title {
  background-color: rgba(<?php echo esc_html($primary_rgb); ?>, 0.8);
}
.estimate-holder {
  background: <?php echo esc_html($primary_color); ?>;
}
<?php
/*-----------------------
#. VC: CTA
------------------------*/
?>
.rt-text-advertise h2 span,
.rt-cta-1 .rtin-cta-contact-button a:hover {
	color: <?php echo esc_html($primary_color); ?>;
}
.rt-cta-2 .rtin-cta-right:before ,
.rt-cta-2 .rtin-cta-right {	
  background-color: <?php echo esc_html($primary_color); ?>;
}
<?php
/*-------------------------------------
#. VC: Law Grid 05
---------------------------------------*/
?>
.rt-service-layout-5 .rtin-single-item .rtin-item-content {
	background-color: rgba(<?php echo esc_html($primary_rgb); ?>, 0.8);
}
.btn-submit {
	background: <?php echo esc_html($primary_color); ?>;
}
.title-bar50:after {
  background: <?php echo esc_html($primary_color); ?>;
}
.rt-text-with-btn h3 span {
  color: <?php echo esc_html($primary_color); ?>;
}
.rt-post-vc-section-5 .sub-title {
  color: <?php echo esc_html($primary_color); ?>;
}
<?php
/*-------------------------------------
#. VC: Pricing Table 1
---------------------------------------*/
?>
.rt-price-table-box h3 {
  color: <?php echo esc_html($primary_color); ?>;
}
.rt-price-table-box .rtin-price-button a.btn-price-button {
  border: 2px solid <?php echo esc_html($primary_color); ?>;
  color: <?php echo esc_html($primary_color); ?>;
}
.rt-price-table-box .rtin-price-button a.btn-price-button:hover {
  background: <?php echo esc_html($primary_color); ?>;
}
<?php
/*-------------------------------------
#. VC: Pricing Table 2
---------------------------------------*/
?>
.entry-content .rt-price-table-box1 .price-holder {
  background: <?php echo esc_html($primary_color); ?>;
}
.rt-text-with-video .rtin-text-content h2::after ,
.entry-content .rt-price-table-box1 .pricetable-btn {
  background-color: <?php echo esc_html($primary_color); ?>;
}
<?php
/*--------------------------------------
#. VC: Logo Showcase
---------------------------------------*/
?>
.rt-vc-counter-2 .rtin-counter-content .rt-counter {
	border: 5px solid <?php echo esc_html($primary_color); ?>;
	color: <?php echo esc_html($primary_color); ?>;
}
<?php
/*--------------------------------------
#. VC: Counter
---------------------------------------*/
?>
.rt-vc-counter-4 .awards-box a {
	border-color: <?php echo esc_html( $primary_color );?>;
}
.rt-vc-counter-4 .awards-box a i {
	background: <?php echo esc_html( $primary_color );?>;
}
<?php
/*-----------
# others
------------*/
?>
.rt-post-vc-section-6 .rtin-single-post .rtin-item-info .rtin-post-date,
.rt-post-vc-section-6 .rtin-single-post:hover .rtin-item-info h3 a {
    color: <?php echo esc_html( $primary_color ); ?>;
}
.rt-cat-list-widget li:before,
.rt-team-slider-nine .team-box .team-content-holder {
    background: <?php echo esc_html( $primary_color );?>;
}