<?php 
/**
* Widget API: Recent Post Widget class
* By : Radius Theme
*/
Class BartaTheme_News_Box extends WP_Widget {
	public function __construct() {
		$widget_ops = array(
			'classname' => 'rt-news-box',
			'description' => esc_html__( 'News Display Widget' , 'barta' ),
			'customize_selective_refresh' => true,
		);
		parent::__construct( 'rt-news-box', esc_html__( 'Barta : Posts display Box' , 'barta' ), $widget_ops );		
	}
	public function widget( $args, $instance ) {
		if ( ! isset( $args['widget_id'] ) ) {
			$args['widget_id'] = $this->id;
		}
		
		$title = ( !empty( $instance['title'] ) ) ? $instance['title'] : esc_html__( 'Recent Posts' , 'barta' );
		$title = apply_filters( 'widget_title', $title, $instance, $this->id_base );
		$number = ( ! empty( $instance['number'] ) ) ? absint( $instance['number'] ) : 6;
		if ( ! $number )
			$number = 6;
		$show_date = isset( $instance['show_date'] ) ? $instance['show_date'] : true;
		$show_cat = isset( $instance['show_cat'] ) ? $instance['show_cat'] : false;
		$show_comment = isset( $instance['show_comment'] ) ? $instance['show_comment'] : true;
		
		$select_style = ( !empty( $instance['select_style'] ) ) ? $instance['select_style'] : 'box-style-1';
		$show_post_image = ( !empty( $instance['show_post_image'] ) ) ? $instance['show_post_image'] : 'yes';
		$bg_color_type = ( !empty( $instance['bg_color_type'] ) ) ? $instance['bg_color_type'] : 'light';
		$post_display_order = ( !empty( $instance['post_display_order'] ) ) ? $instance['post_display_order'] : 'view';
		$show_no_preview_img = ( !empty( $instance['show_no_preview_img'] ) ) ? $instance['show_no_preview_img'] : 'none';
		
		if ( $post_display_order == 'view' ) {
		
			$result_query = new WP_Query( apply_filters( 'widget_posts_args', array(
				'posts_per_page'      => $number,
				'no_found_rows'       => true,
				'post_status'         => 'publish',
				'orderby'   		  => 'meta_value_num',
				'meta_key'  		  => 'barta_views',
				'ignore_sticky_posts' => true
			) ) );
		
		} else if ( $post_display_order == 'comment' ) {

			$result_query = new WP_Query( apply_filters( 'widget_posts_args', array(
				'posts_per_page'      => $number,
				'post_status'         => 'publish',
				'orderby'   		  => 'comment_count',
				'ignore_sticky_posts' => true
			) ) );
		
		} else {
			
			$result_query = new WP_Query( apply_filters( 'widget_posts_args', array(
				'posts_per_page'      => $number,
				'no_found_rows'       => true,
				'post_status'         => 'publish',
				'ignore_sticky_posts' => true
			) ) );			
		}
		
		if ($result_query->have_posts()) :
		?>
		<?php echo wp_kses_post($args['before_widget']); ?>
		<?php if ( $title ) {
			echo wp_kses_post($args['before_title']) . $title . wp_kses_post($args['after_title']);
		} ?>
		<div class="<?php if ( $select_style == 'box-style-2' ) { ?>row<?php } ?> <?php echo esc_attr( $bg_color_type ); ?>">
		<?php while ( $result_query->have_posts() ) : $result_query->the_post(); ?>
			<?php if ( $select_style == 'box-style-1' ) { ?>
			<div class="rt-news-box-widget <?php echo esc_attr( $select_style ); ?>">
				<?php if ( $show_post_image == 'yes' ) { ?>
					<?php if ( has_post_thumbnail() ){ ?>
						<?php if ( $show_cat ) { ?>
						<?php						
							$get_color  = get_term_meta( barta_get_primary_category()[0]->term_id , 'rt_category_color', true );
							
							if ( $get_color ) {	?>
								<a href="<?php echo get_category_link( barta_get_primary_category()[0]->term_id ); ?>"><span class="el-rt-cat style_2" style="background:#<?php echo esc_attr( $get_color ); ?>"><?php echo esc_html( barta_get_primary_category()[0]->name ); ?><span class="titleinner" style="border-top: 8px solid #<?php echo esc_attr( $get_color ); ?>;" ></span></span></a>
							<?php } else { ?>
								<a href="<?php echo get_category_link( barta_get_primary_category()[0]->term_id ); ?>"><span class="el-rt-cat style_2"><?php echo esc_html( barta_get_primary_category()[0]->name ); ?><span class="titleinner"></span></span></a>
							<?php }						
						} ?>
					<?php } ?>
				<?php } ?>
				<div class="media">
					<?php if ( $show_post_image == 'yes' ) { ?>
						<?php if ( has_post_thumbnail() ){ ?>
							<a class="post-img-holder img-opacity-hover" href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>"><?php
									if ( has_post_thumbnail() ){
										the_post_thumbnail( 'barta-size3', ['class' => 'media-object'] );
									} else {
										if ( $show_no_preview_img == 'view' ) { ?>
											<img class="rt-lazy" src="<?php echo esc_url( BARTA_IMG_URL ); ?>noimage_375X300.jpg" alt="<?php the_title_attribute(); ?>">
									<?php }
									}
								?></a>
						<?php } ?>
					<?php } ?>
					<div class="media-body">
						<?php if ( $show_date ) { ?>
							<div class="post-date-dark">
								<ul>
									<li>
										<span><i class="fa fa-clock-o" aria-hidden="true"></i></span><?php echo get_the_time( get_option( 'date_format' ) ); ?>
									</li>
								</ul>
							</div>
						<?php } ?>
						<h3 class="title-medium-dark mb-none">
							<a href="<?php the_permalink(); ?>"><?php the_title(); ?> </a>
						</h3>
					</div>
				</div>
			</div>
			<?php } else if ( $select_style == 'box-style-2' ) { ?>
			<div class="col-lg-6 col-md-12 col-sm-6 col-xs-12 <?php echo esc_attr( $select_style ); ?>">
				<div class="topic-box">				
					<?php if ( has_post_thumbnail() ){ ?>
						<?php if ( $show_cat ) { ?>							
							<?php 								
							$get_color  = get_term_meta( barta_get_primary_category()[0]->term_id , 'rt_category_color', true );
							
							if ( $get_color ) {	?>
								<a href="<?php echo get_category_link( barta_get_primary_category()[0]->term_id ); ?>"><span class="el-rt-cat style_2" style="background:#<?php echo esc_attr( $get_color ); ?>"><?php echo esc_html( barta_get_primary_category()[0]->name ); ?><span class="titleinner" style="border-top: 8px solid #<?php echo esc_attr( $get_color ); ?>;" ></span></span></a>
							<?php } else { ?>
								<a href="<?php echo get_category_link( barta_get_primary_category()[0]->term_id ); ?>"><span class="el-rt-cat style_2"><?php echo esc_html( barta_get_primary_category()[0]->name ); ?><span class="titleinner"></span></span></a>
							<?php } ?>
						<?php } ?>
					<?php } ?>
					<?php if ( $show_post_image == 'yes' ) { ?>
						<?php if ( has_post_thumbnail() ){ ?>
						<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>" class="rt-wid-post-img img-opacity-hover">
							<?php
								if ( has_post_thumbnail() ){
									the_post_thumbnail( 'barta-size3', ['class' => 'media-object'] );
								} else {
									if ( $show_no_preview_img == 'view' ) { ?>
										<img class="rt-lazy" src="<?php echo esc_url( BARTA_IMG_URL ); ?>noimage_375X300.jpg" alt="<?php the_title_attribute(); ?>">
								<?php }
								}
							?>
						</a>
						<?php } ?>
					<?php } ?>
					<?php if ( $show_date ) { ?>
					<div class="posted-date"><i class="fa fa-clock-o" aria-hidden="true"></i><?php echo get_the_time( get_option( 'date_format' ) ); ?></div>
					<?php } ?>
					<h3 class="widget-recent-post-title">
						<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
					</h3>
				</div>
			</div>
			<?php } ?>
			
		<?php endwhile; ?>
		</div>
		<?php echo wp_kses_post($args['after_widget']); ?>
		<?php
		wp_reset_postdata();
		endif;
	}
	
	public function update( $new_instance, $old_instance ) {
		$instance 				  = $old_instance;
		$instance['title'] 		  = sanitize_text_field( $new_instance['title'] );
		$instance['number'] 	  = (int) $new_instance['number'];
		$instance['show_date']    = isset( $new_instance['show_date'] ) ? (bool) $new_instance['show_date'] : false;
		$instance['show_cat']     = isset( $new_instance['show_cat'] ) ? (bool) $new_instance['show_cat'] : false;
		$instance['show_comment'] = isset( $new_instance['show_comment'] ) ? (bool) $new_instance['show_comment'] : false;
		$instance['select_style'] = isset( $new_instance['select_style'] ) ? $new_instance['select_style'] : 'box-style-1';
		$instance['show_post_image'] = isset( $new_instance['show_post_image'] ) ? $new_instance['show_post_image'] : 'yes';
		$instance['bg_color_type'] = isset( $new_instance['bg_color_type'] ) ? $new_instance['bg_color_type'] : 'light';
		$instance['post_display_order'] = isset( $new_instance['post_display_order'] ) ? $new_instance['post_display_order'] : 'view';
		$instance['show_no_preview_img'] = isset( $new_instance['show_no_preview_img'] ) ? $new_instance['show_no_preview_img'] : 'none';
		return $instance;
	}
	
	public function form( $instance ) {
		$title     = isset( $instance['title'] ) ? esc_attr( $instance['title'] ) : '';
		$number    = isset( $instance['number'] ) ? absint( $instance['number'] ) : 6;
		$show_date = isset( $instance['show_date'] ) ? (bool) $instance['show_date'] : false;
		$show_cat = isset( $instance['show_cat'] ) ? (bool) $instance['show_cat'] : false;
		$show_comment = isset( $instance['show_comment'] ) ? (bool) $instance['show_comment'] : false;
		$select_style = ( !empty( $instance['select_style'] ) ) ? $instance['select_style'] : 'box-style-1';
		$show_post_image = ( !empty( $instance['show_post_image'] ) ) ? $instance['show_post_image'] : 'yes';
		$bg_color_type = ( !empty( $instance['bg_color_type'] ) ) ? $instance['bg_color_type'] : 'light';
		$post_display_order = ( !empty( $instance['post_display_order'] ) ) ? $instance['post_display_order'] : 'view';
		$show_no_preview_img = ( !empty( $instance['show_no_preview_img'] ) ) ? $instance['show_no_preview_img'] : 'none';
		?>
			<p><label for="<?php echo esc_attr( $this->get_field_id( 'title' )); ?>"><?php echo esc_html__( 'Title:' , 'barta' ); ?></label>
			<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' )); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' )); ?>" type="text" value="<?php echo esc_attr( $title); ?>" /></p>
			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'post_display_order' )); ?>"><?php esc_html_e( 'Post Display Order : ', 'barta'  ); ?></label>
				<select name="<?php echo esc_attr( $this->get_field_name( 'post_display_order' )); ?>">
					<option <?php if ( $post_display_order == 'none' ) {  echo 'selected'; } ?> value="none"><?php esc_html_e( 'Recent' , 'barta' ); ?></option>
					<option <?php if ( $post_display_order == 'view' ) {  echo 'selected'; } ?> value="view"><?php esc_html_e( 'Most Viewed' , 'barta' ); ?></option>
					<option <?php if ( $post_display_order == 'comment' ) {  echo 'selected'; } ?> value="comment"><?php esc_html_e( 'Most Commented' , 'barta' ); ?></option>
				</select>
			</p>
			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'show_no_preview_img' )); ?>"><?php esc_html_e( 'Show no preview image : ' , 'barta' ); ?></label>
				<select name="<?php echo esc_attr( $this->get_field_name( 'show_no_preview_img' )); ?>">
					<option <?php if ( $show_no_preview_img == 'none' ) {  echo 'selected'; } ?> value="none"><?php esc_html_e( 'Hide' , 'barta' ); ?></option>
					<option <?php if ( $show_no_preview_img == 'view' ) {  echo 'selected'; } ?> value="view"><?php esc_html_e( 'Show' , 'barta' ); ?></option>
				</select>
			</p>
			<p><label for="<?php echo esc_attr( $this->get_field_id( 'number' )); ?>"><?php esc_html_e( 'Number of posts to show:', 'barta' ); ?></label>
			<input class="tiny-text" id="<?php echo esc_attr( $this->get_field_id( 'number' )); ?>" name="<?php echo esc_attr( $this->get_field_name( 'number' )); ?>" type="number" step="1" min="1" value="<?php echo esc_attr( $number); ?>" size="3" /></p>

			<p><input class="checkbox" type="checkbox"<?php checked( $show_date ); ?> id="<?php echo esc_attr( $this->get_field_id( 'show_date' )); ?>" name="<?php echo esc_attr( $this->get_field_name( 'show_date' )); ?>" />
			<label for="<?php echo esc_attr( $this->get_field_id( 'show_date' )); ?>"><?php esc_html_e( 'Display post date?' , 'barta'); ?></label></p>
			
			<p><input class="checkbox" type="checkbox"<?php checked( $show_cat ); ?> id="<?php echo esc_attr( $this->get_field_id( 'show_cat' )); ?>" name="<?php echo esc_attr( $this->get_field_name( 'show_cat' )); ?>" />
			<label for="<?php echo esc_attr( $this->get_field_id( 'show_cat' )); ?>"><?php esc_html_e( 'Display post category?', 'barta' ); ?></label></p>
			
			<p><input class="checkbox" type="checkbox"<?php checked( $show_comment ); ?> id="<?php echo esc_attr( $this->get_field_id( 'show_comment' )); ?>" name="<?php echo esc_attr( $this->get_field_name( 'show_comment' )); ?>" />
			<label for="<?php echo esc_attr( $this->get_field_id( 'show_comment' )); ?>"><?php esc_html_e( 'Display Number of post Comments?', 'barta' ); ?></label></p>			
			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'select_style' )); ?>"><?php esc_html_e( 'Select Box Style : ', 'barta' ); ?></label>
				<select name="<?php echo esc_attr( $this->get_field_name( 'select_style' )); ?>">
					<option <?php if ( $select_style == 'box-style-1' ) {  echo 'selected'; } ?> value="box-style-1"><?php esc_html_e( 'Style 1' , 'barta' ); ?></option>
					<option <?php if ( $select_style == 'box-style-2' ) {  echo 'selected'; } ?> value="box-style-2"><?php esc_html_e( 'Style 2' , 'barta' ); ?></option>
				</select>
			</p>
			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'show_post_image' )); ?>"><?php esc_html_e( 'Show Post Image : ', 'barta' ); ?></label>
				<select name="<?php echo esc_attr( $this->get_field_name( 'show_post_image' )); ?>">
					<option <?php if ( $show_post_image == 'yes' ) {  echo 'selected'; } ?> value="yes"><?php esc_html_e( 'Display' , 'barta' ); ?></option>
					<option <?php if ( $show_post_image == 'no' ) {  echo 'selected'; } ?> value="no"><?php esc_html_e( 'Hide' , 'barta' ); ?></option>
				</select>
			</p>
			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'bg_color_type' )); ?>"><?php esc_html_e( 'Select Background Color Type : ', 'barta' ); ?></label>
				<select name="<?php echo esc_attr( $this->get_field_name( 'bg_color_type' )); ?>">
					<option <?php if ( $bg_color_type == 'light' ) {  echo 'selected'; } ?> value="light"><?php esc_html_e( 'Light' , 'barta' ); ?></option>
					<option <?php if ( $bg_color_type == 'dark' ) {  echo 'selected'; } ?> value="dark"><?php esc_html_e( 'Dark' , 'barta' ); ?></option>
				</select>
			</p>
		<?php
	}	
}