<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

// Layout class
if ( BartaTheme::$layout == 'full-width' ) {
	$barta_layout_class = 'col-sm-12 col-xs-12';
} else {
	$barta_layout_class = 'col-lg-9 col-md-12 col-12';
}
$barta_is_post_archive = is_home() || ( is_archive() && get_post_type() == 'post' ) ? true : false;
$termID = 0;
$taxonomy = null;

if ( is_archive() ) {
	$obj = get_the_category();	
	$termID = $obj[0]->term_id;
	$taxonomy = $obj[0]->taxonomy;	
}
?>
<?php get_header(); ?>
<div id="primary" class="content-area">
	<div class="container">
		<div class="row">
			<?php if ( BartaTheme::$layout == 'left-sidebar' ) { get_sidebar(); } ?>
			<div class="<?php echo esc_attr( $barta_layout_class );?>">
				<main id="main" class="site-main">				
				<?php
					if ( !empty( BartaTheme::$options['load_more_option'] ) && BartaTheme::$options['load_more_option'] == 'pagination' ) {
						$more_wrapper_class = 'barta-pagination';
					} else if ( BartaTheme::$options['load_more_option'] == 'load_more' ) {
						$more_wrapper_class = 'barta-loadmore';
					} else {
						$more_wrapper_class = 'barta-infinity-scroll';
					}
					
					if ( have_posts() ) { ?>
						<?php
						if ( $barta_is_post_archive && BartaTheme::$options['blog_style'] == 'style5' ) {
							echo '<div class="blog-layouts blog-layout-5 row rt-masonry-grid ' . $more_wrapper_class  . '">';
							while ( have_posts() ) : the_post();
								get_template_part( 'template-parts/content-5-masonry', get_post_format() );
							endwhile;
							echo '</div>';
						} else if ( $barta_is_post_archive && BartaTheme::$options['blog_style'] == 'style4' ) {
							echo '<div data-taxonomy="'. $taxonomy .'" data-termID="'.$termID.'" class="blog-layouts blog-layout-4 row rt-masonry-grid ' . $more_wrapper_class  . '">';
							while ( have_posts() ) : the_post();
								get_template_part( 'template-parts/content-4-masonry', get_post_format() );
							endwhile;
							echo '</div>';
						} else if ( $barta_is_post_archive && BartaTheme::$options['blog_style'] == 'style3' ) {
							echo '<div data-taxonomy="'. $taxonomy .'" data-termID="'. $termID .'" class="blog-layouts blog-layout-3 ' . $more_wrapper_class  . '" data-layout="'. esc_attr( BartaTheme::$layout ) .'">';
							while ( have_posts() ) : the_post();
								get_template_part( 'template-parts/content-3', get_post_format() );
							endwhile;
							echo '</div>';
						} else if ( $barta_is_post_archive && BartaTheme::$options['blog_style'] == 'style2' ) {
							echo '<div data-taxonomy="'. $taxonomy .'" data-termID="'.$termID.'" class="row blog-layouts auto-clear ' . $more_wrapper_class  . '">';
							while ( have_posts() ) : the_post();
								get_template_part( 'template-parts/content-2', get_post_format() );
							endwhile;
							echo '</div>';
						} else if ( $barta_is_post_archive && BartaTheme::$options['blog_style'] == 'style1' ) {
							echo '<div data-taxonomy="'. $taxonomy .'" data-termID="'. $termID .'" class="auto-clear ' . $more_wrapper_class  . ' blog-layouts ajax-content-wrapper">';
							echo category_description();
							while ( have_posts() ) : the_post();
								get_template_part( 'template-parts/content-1', get_post_format() );
							endwhile;
							echo '</div>';
						}
						else {
							while ( have_posts() ) : the_post();
								get_template_part( 'template-parts/content-1', get_post_format() );
							endwhile;
						}

						?>
						<?php							
							if ( BartaTheme::$options['load_more_option'] == 'pagination' ) {
								BartaTheme_Helper::pagination();
							} else if ( BartaTheme::$options['load_more_option'] == 'load_more' ) {								
								BartaTheme_Helper::load_more();
							} else {
								BartaTheme_Helper::infinity();
							}
						?>
						
					<?php } else {?>
						<?php get_template_part( 'template-parts/content', 'none' );?>
					<?php } ?>
				</main>
			</div>
			<?php
			if ( BartaTheme::$layout == 'right-sidebar' ) {
				get_sidebar();
			}
			?>
		</div>
	</div>
</div>
<?php get_footer(); ?>