<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

$barta_has_entry_meta  = ( ( !has_post_thumbnail() && BartaTheme::$options['post_date'] ) || BartaTheme::$options['post_author_name'] || BartaTheme::$options['post_comment_num'] || BartaTheme::$options['post_cats'] ) ? true : false;

$barta_comments_number = number_format_i18n( get_comments_number() );
$barta_comments_html = $barta_comments_number < 2 ? esc_html__( 'Comment' , 'barta' ) : esc_html__( 'Comments' , 'barta' );
$barta_comments_html = '('. $barta_comments_number . ') ' . $barta_comments_html;
$barta_author_bio      = get_the_author_meta( 'description' );

$subtitle = get_post_meta( get_the_ID(), 'barta_subtitle', true );
$author = $post->post_author;

$news_author_fb = get_user_meta( $author, 'barta_facebook', true );
$news_author_tw = get_user_meta( $author, 'barta_twitter', true );
$news_author_ld = get_user_meta( $author, 'barta_linkedin', true );
$news_author_gp = get_user_meta( $author, 'barta_gplus', true );
$news_author_pr = get_user_meta( $author, 'barta_pinterest', true );
$barta_author_designation = get_user_meta( $author, 'barta_author_designation', true );

// Layout class
if ( BartaTheme::$layout == 'full-width' ) {
	$barta_layout_class = 'col-sm-12 col-xs-12';
} else {
	$barta_layout_class = 'col-xl-9 col-lg-9 col-md-12';
}
/*Featured Image caption*/
if ( !empty( BartaTheme::$options['show_caption'] ) && BartaTheme::$options['show_caption'] == true ) {
	
	/*alignment*/
	if ( !empty( BartaTheme::$options['show_caption_align'] ) && BartaTheme::$options['show_caption_align'] == 'cap_right' ) {
		$cap_align_class = 'text-right';
	} else if ( !empty( BartaTheme::$options['show_caption_align'] ) && BartaTheme::$options['show_caption_align'] == 'cap_left' ) {
		$cap_align_class = 'text-left';
	} else if ( !empty( BartaTheme::$options['show_caption_align'] ) && BartaTheme::$options['show_caption_align'] == 'cap_center' ) {
		$cap_align_class = 'text-center';
	} else {
		$cap_align_class = 'text-justify';
	}
	if ( !empty( BartaTheme::$options['show_caption_place'] )) {
		$caption_place_class = BartaTheme::$options['show_caption_place'];
	}
}

?>
<!-- new layout --->
	<?php if ( BartaTheme::$options['post_featured_image'] == true ) { ?>
		<?php if ( has_post_thumbnail() ) { ?>
			<div class="position-relative inner-page-banner">
				<div class="entry-thumbnail-area <?php echo esc_attr( $caption_place_class ); ?> img-overlay-70 position-relative">
					<?php the_post_thumbnail( 'full' , ['class' => 'img-fluid'] ); ?>
					<div class="container">
						<div class="banner-content">
							<?php							
								$categories = get_the_category();
								$separator = ' ';
								$output = '';
								if ( ! empty( $categories ) ) {
									foreach( $categories as $category ) {
									$get_color  = get_term_meta( $category->term_id , 'rt_category_color', true );
							
									if ( $get_color ) {	?>
										<a href="<?php echo get_category_link( $category->term_id ); ?>"><span class="el-rt-cat style_2" style="background:#<?php echo esc_attr( $get_color ); ?>"><?php echo esc_html( $category->name ); ?><span class="titleinner" style="border-top: 8px solid #<?php echo esc_attr( $get_color ); ?>;" ></span></span></a>
									<?php } else { ?>
										<a href="<?php echo get_category_link( $category->term_id ); ?>"><span class="el-rt-cat style_2"><?php echo esc_html( $category->name ); ?><span class="titleinner"></span></span></a>
									<?php } 
									}
								}
							?>
							<h2 class="inner-banner-title entry-title"><?php echo get_the_title(); ?></h2>
							<ul class="post-info-dark hidden-sm hidden-xs">
								<?php if ( BartaTheme::$options['post_author_name'] == '1' ) { ?>
								<li><span><i class="fa fa-user" aria-hidden="true"></i></span> <?php printf('<a href="%1$s"><span class="vcard author author_name"><span class="fn">%2$s</span></span></a>',esc_url( get_author_posts_url( get_the_author_meta('ID', $author) ) ),get_the_author_meta('display_name', $author)); ?></li>
								<?php } ?>
								<?php if ( BartaTheme::$options['post_date'] ) { ?>
								<li><i class="fa fa-clock-o" aria-hidden="true"></i><span class="published updated"><?php echo get_the_date(); ?></span></li>
								
								<li><span><i class="fa fa-clock-o" aria-hidden="true"></i></span><?php esc_html_e( 'Latest Update:','barta' ); ?> <?php echo get_post_modified_time(get_option( 'date_format' ) .' '. get_option( 'time_format' ), false, null, true); ?></li>
								
								<?php } ?>
								<?php if ( BartaTheme::$options['post_view'] && function_exists( 'barta_views' ) ) { ?>
								<li><?php echo barta_views(); ?></li>
								<?php } ?>
								<?php if ( BartaTheme::$options['post_length'] && function_exists( 'barta_reading_time' ) ) { ?>
								<li><span class="meta-reading-time meta-item"> <?php echo barta_reading_time(); ?></span></li>
								<?php } ?>
								<?php if ( BartaTheme::$options['post_comment_num'] ) { ?>
								<li><i class="fa fa-comments" aria-hidden="true"></i> <?php comments_number( '0', '1', '%' ); ?></li><?php } ?>
							</ul>
						</div>
					</div>
					<?php if ( !empty( BartaTheme::$options['show_caption'] ) && BartaTheme::$options['show_caption'] == true ) { ?>
						<?php if (get_post(get_post_thumbnail_id())->post_excerpt) { ?>
							<div class="featured-image-caption <?php echo esc_attr( $cap_align_class ); ?>"><?php echo wp_kses_post(get_post(get_post_thumbnail_id())->post_excerpt); ?></div>
						<?php } ?>
					<?php } ?>					
				</div>
			</div>
		<?php } ?>
	<?php } ?>	
	<!-- Breadcrumb Area Start Here -->
	<section class="breadcrumbs-area2">
		<div class="container">
			<div class="breadcrumbs-content">				
				<?php if ( is_singular () ) { ?>
				<h3 class="entry-category">
					<?php
						$categories = get_the_category();
						$count = count( $categories );
						$i = 0;
						if ( ! empty( $categories ) ) {
							foreach( $categories as $category ) {
							 $i++;
							?><a href="<?php echo get_category_link( $category->term_id ); ?>"><?php echo esc_html( $category->name ); ?></a><?php if ( $count != $i ) {	echo ', '; }
							}
						}
					?>
				</h3>
				<?php } ?>				
				<?php if ( BartaTheme::$has_breadcrumb == '1' || BartaTheme::$has_breadcrumb == 'on' ) { ?>
					<?php get_template_part( 'template-parts/content', 'breadcrumb' );?>
				<?php } ?>				
			</div>
		</div>
	</section>
	<!-- Breadcrumb Area End Here -->
	<?php
		$is_ad_active3 = get_post_meta( get_the_ID(), 'barta_content_top', true );
		if ( $is_ad_active3 == 'on' ) {
			do_action( 'barta_before_content' );
		}
	?>
	<section class="content-holder">
		<div class="container">
			<div class="row">	
			<?php if ( BartaTheme::$layout == 'left-sidebar' ) { ?>
				<?php get_sidebar(); ?>
			<?php } ?>

	<div id="post-<?php the_ID(); ?>" <?php post_class( $barta_layout_class); ?> class="<?php echo esc_attr( $barta_layout_class );?>">
			
				<div class="post-detail-holder">					
					<?php if ( BartaTheme::$has_banner == '0' || BartaTheme::$has_banner == 'off'  ) { ?>
						<h1 class="entry-title"><?php echo get_the_title(); ?></h1>					
					<?php } ?>
					<?php if ( !has_post_thumbnail() ) { ?>
						<div class="post-2-no-img-meta post-info-light">
							<ul class="entry-meta">
								<?php if ( BartaTheme::$options['post_author_name'] == '1' ) { ?>
								<li><span><i class="fa fa-user" aria-hidden="true"></i></span> <?php printf('<a href="%1$s"><span class="vcard author author_name"><span class="fn">%2$s</span></span></a>',esc_url( get_author_posts_url( get_the_author_meta('ID', $author) ) ),get_the_author_meta('display_name', $author)); ?></li>
								<?php } ?>
								<?php if ( BartaTheme::$options['post_date'] ) { ?>
								<li><span><i class="fa fa-clock-o" aria-hidden="true"></i></span><span class="published updated"><?php echo get_the_date(); ?></span></li>
								<li><span><i class="fa fa-clock-o" aria-hidden="true"></i></span><?php esc_html_e( 'Latest Update:','barta' ); ?> <?php echo get_post_modified_time(get_option( 'date_format' ) .' '. get_option( 'time_format' ), false, null, true); ?></li>
								<?php } ?>
								<?php if ( BartaTheme::$options['post_view'] && function_exists( 'barta_views' ) ) { ?>
								<li><?php echo barta_views(); ?></li>
								<?php } ?>
								<?php if ( BartaTheme::$options['post_length'] && function_exists( 'barta_reading_time' ) ) { ?>
								<li><span class="meta-reading-time meta-item"> <?php echo barta_reading_time(); ?></span></li>
								<?php } ?>
								<?php if ( BartaTheme::$options['post_comment_num'] ) { ?>
								<li><i class="fa fa-comments" aria-hidden="true"></i> <?php comments_number( '0', '1', '%' ); ?></li><?php } ?>
							</ul>
						</div>
					<?php } ?>
					<?php if ( !empty( $subtitle ) && BartaTheme::$options['post_subtitle'] ) { ?>
						<h3 class="entry-sub-title"><?php echo wp_kses_post( $subtitle ); ?></h3>
					<?php } ?>
					<?php if ( BartaTheme::$options['post_share_display_top'] == '1' ) { ?>	
					<?php if( function_exists( 'barta_post_share' )){ barta_post_share(); } ?>
					<?php } ?>
					
					<div class="entry-content"><?php the_content();?><?php wp_link_pages();?></div>
				
					<?php if ( BartaTheme::$options['post_tags'] && has_tag() ) { ?>
					<div class="entry-footer">
						<div class="entry-footer-meta">
							<div class="item-tags">
								<span><?php esc_html_e( 'Tags:', 'barta' ); ?></span><?php echo get_the_term_list( $post->ID, 'post_tag', '<ul class="blog-tags item-inline tag_styles"><li>', '</li><li>', '</li></ul>' );?>
							</div>
						</div>
					</div>
					<?php } ?>
					<?php
						$is_ad_active4 = get_post_meta( get_the_ID(), 'barta_content_below', true );
						if ( $is_ad_active4 == 'on' ) {
							do_action( 'barta_after_content' );
						}
					?>
					<?php if ( ( BartaTheme::$options['post_share_display_footer'] == '1') && function_exists( 'barta_post_share' ) ) { ?>	
						<div class="post-share-area post-footer-share">
							<p><?php esc_html_e( 'You can share this post!', 'barta' ); ?></p>
							<?php barta_post_share(); ?>
						</div>	
					<?php } ?>					
				</div>
				
				<?php if ( BartaTheme::$options['post_links'] ) { barta_post_links_next_prev(); } ?>
				
				<!-- author bio -->
				<?php if ( BartaTheme::$options['post_author_bio'] == '1' ) { ?>
					<div class="media about-author">
						<div class="<?php if ( is_rtl() ) { ?>pull-right<?php } else { ?>pull-left<?php } ?>">
							<?php echo get_avatar( $author, 105 ); ?>
						</div>
						<div class="media-body">
							<div class="about-author-info">
								<div class="author-title"><?php the_author_posts_link();?></div>
								<div class="author-designation"><?php if ( !empty ( $barta_author_designation ) ) {	echo esc_html( $barta_author_designation ); } else {	$user_info = get_userdata( $author ); echo esc_html ( implode( ', ', $user_info->roles ) );	} ?></div>
							</div>
							<?php if ( $barta_author_bio ) { ?>
							<div class="author-bio"><?php echo esc_html( $barta_author_bio );?></div>
							<?php } ?>
							<div class="about-author-social">
								<?php ?>
									<ul class="author-box-social">
										<?php if ( ! empty( $news_author_fb ) ){ ?><a href="<?php echo esc_attr( $news_author_fb ); ?>"><li><i class="fa fa-facebook" aria-hidden="true"></i></li></a><?php } ?>
										<?php if ( ! empty( $news_author_tw ) ){ ?><a href="<?php echo esc_attr( $news_author_tw ); ?>"><li><i class="fa fa-twitter" aria-hidden="true"></i></li></a><?php } ?>
										<?php if ( ! empty( $news_author_gp ) ){ ?><a href="<?php echo esc_attr( $news_author_gp ); ?>"><li><i class="fa fa-google-plus" aria-hidden="true"></i></li></a><?php } ?>
										<?php if ( ! empty( $news_author_ld ) ){ ?><a href="<?php echo esc_attr( $news_author_ld ); ?>"><li><i class="fa fa-linkedin" aria-hidden="true"></i></li></a><?php } ?>
										<?php if ( ! empty( $news_author_pr ) ){ ?><a href="<?php echo esc_attr( $news_author_pr ); ?>"><li><i class="fa fa-pinterest-p" aria-hidden="true"></i></li></a><?php } ?>
									</ul>
								<?php ?>
							</div>
						</div>
						<div class="clear"></div>
					</div>
				<?php } ?>
				
				<?php if( BartaTheme::$options['show_related_post'] == '1' && is_single() ) { ?>
				<div class="related-post">
					<?php barta_related_post(); ?>
				</div>
				<?php } ?>
				
				<?php
					if ( comments_open() || get_comments_number() ){
						comments_template();
					}
				?>
			</div>
			
			<?php if ( BartaTheme::$layout == 'right-sidebar' ) { ?>
				<?php get_sidebar(); ?>
			<?php } ?>
			</div>
		</div>
	</section>