<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

$barta_socials = BartaTheme_Helper::socials();
?>
<?php if ( !empty( BartaTheme::$options['phone'] ) && !empty( BartaTheme::$options['email'] ) && !empty( $barta_socials ) ) { ?>
<div id="tophead" class="header-top-bar align-items-center">
	<div class="container">
		<div class="row">
		
			<div class="col-sm-12">
				<div class="tophead-contact">
					<ul>
						<?php if ( BartaTheme::$options['phone'] ): ?>
							<li>
								<i class="fa fa-phone" aria-hidden="true"></i><a href="tel:<?php echo esc_attr( BartaTheme::$options['phone'] );?>"><?php echo esc_html( BartaTheme::$options['phone'] );?></a>
							</li>
						<?php endif; ?>
						<?php if ( BartaTheme::$options['email'] ): ?>
							<li>
								<i class="fa fa-envelope-o" aria-hidden="true"></i><a href="mailto:<?php echo esc_attr( BartaTheme::$options['email'] );?>"><?php echo esc_html( BartaTheme::$options['email'] );?></a>
							</li>
						<?php endif; ?>
					</ul>
				</div>
				<div class="tophead-right">
					<?php if ( $barta_socials ): ?>
						<ul class="tophead-social">
							<?php foreach ( $barta_socials as $barta_social ): ?>
								<li><a target="_blank" href="<?php echo esc_url( $barta_social['url'] );?>"><i class="fa <?php echo esc_attr( $barta_social['icon'] );?>"></i></a></li>
							<?php endforeach; ?>
						</ul>
					<?php endif; ?>
				</div>
				<div class="clear"></div>
			</div>
		</div>
	</div>
</div>
<?php } ?>