<?php
/**
 * The Template Name: Filter Template Page
 *
 */

get_header();

if ( get_query_var('paged') ) {
	$paged = get_query_var('paged');
}
else if ( get_query_var('page') ) {
	$paged = get_query_var('page');
}
else {
	$paged = 1;
}
?>

<div class="container">
	<div class="pagewraps">
		<div class="row">
			<div class="col-sm-3 col-12">
				<div class="filter-wrapper">
					<?php
					//query for post categories		
						$categories = get_categories( array(
							'orderby' => 'name',
							'order'   => 'ASC'
						) );
					?>
					<div class="filter-title">
					<h3>FILTERS</h3> <span>Clear</span>
					</div>
					
					<h4>News Type</h4>
					<form class="br-filter-form">
					<ul class="search-items" style="list-style: none">
					<?php						
						foreach( $categories as $category ) { ?>
						<li>
							<div class="checkbox checkbox-primary">
								<input class="boxes" id="<?php echo esc_html ( $category->term_id ); ?>" type="checkbox" value="<?php echo esc_html ( $category->term_id ); ?>" name="post_cat">
								<label for="<?php echo esc_html( $category->term_id ); ?>"><?php echo esc_html( $category->name ); ?> (<?php echo esc_html( $category->count ); ?> )</label>
							</div>
						</li>
						<?php } ?>
					</ul>
					<?php wp_nonce_field( 'ranna-nonce', '_nonce', false, true ); ?>
					<button type="submit" class="filter-button btn btn-warning">Apply</button>
					</form>
				</div>
				<?php if ( is_active_sidebar( 'left-sidebar' ) ) : ?>   
					<?php dynamic_sidebar( 'left-sidebar' ); ?>					
				<?php endif; ?>
			</div>	
			
			<div class="col-sm-9 col-12"><div class="count-post"><span><?php echo wp_count_posts()->publish; ?></span> Result</div>
				<section class="site-content-wrap">
					
					<div class="row">
						
						<?php
						// number
						$args = array(
							'post_type' => 'post',
							'post_status' => 'publish',
							'posts_per_page' => 10,
							'paged'     => $paged,
						);

						$taxQ = [];
						if (!empty($post_cat)) {
							$taxQ[] = array(
								'taxonomy' => 'category',
								'field'    => 'term_id',
								'terms'    => $post_cat,
							);
						}


						if (!empty($taxQ)
							//&& count($taxQ) > 1
						) {
							$taxQ['relation'] = "AND";
							$args['tax_query'] = $taxQ;
						}


						$query = new WP_Query($args);
						//print_r( $query );
						$temp = BartaTheme_Helper::wp_set_temp_query($query);

						if ($query->have_posts()) {
							while ($query->have_posts()) {
								$query->the_post();
								$content = wp_trim_words(get_the_excerpt(), 15, '');
								$title = wp_trim_words(get_the_title(), 10, '');
								$formatted_post_date = get_the_date();


								$cats = get_the_term_list(get_the_ID(), 'category', '<span class="sub-title">', ', </span><span class="sub-title">', '</span></span>');
								/*echo $query->post_count;
								echo $query->found_posts;*/
								?>
								<div class="col-xl-4 col-lg-4 col-md-4 col-sm-6 col-12">
									<div class="product-box-layout3">
										<a href="<?php the_permalink(); ?>">
											<?php
											if (has_post_thumbnail()) {
												the_post_thumbnail($thumb_size);
											}
											?>
										</a>
										<div class="item-content">
											<?php if (!empty($cats)) { ?><span
													class="sub-title"><?php echo wp_kses_post($cats); ?> </span><?php } ?>
											<h3 class="item-title"><a
														href="<?php the_permalink(); ?>"><?php echo esc_html($title); ?></a>
											</h3>
											<p><?php echo wp_kses_post($content); ?></p>
											<ul class="entry-meta" style="list-style: none;">
												<li class="author-meta"><i class="fa fa-user" aria-hidden="true"></i><?php esc_html_e('by ', 'ranna-core'); the_author_posts_link(); ?></li>
											</ul>
										</div>
									</div>
								</div>

							<?php } ?>
							<?php							
								// Previous/next post navigation. ( IT IS WORKING FINE )
								/*the_posts_pagination( array(
									'mid_size' => 2,
									'prev_text' => __( 'Back', 'twenty-minutes' ),
									'next_text' => __( 'Next', 'twenty-minutes' ),
									'screen_reader_text' => __( 'Posts navigation', 'twenty-minutes' )
								) );  */				
							?>
							<div class="mt20 col-sm-12 col--12 pagination-wrapper"><?php BartaTheme_Helper::pagination();?></div>
						<?php } else { ?>

						<?php } ?>
						<?php BartaTheme_Helper::wp_reset_temp_query($temp); ?>
					</div>
				</section><!-- section-->
			</div>
		</div>	
	</div><!-- .pagewraps --> 
 </div><!-- .container -->
 
<?php get_footer(); ?>