<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */
namespace radiustheme\Barta_Core;

use BartaTheme;
use BartaTheme_Helper;

use \WP_Query;

$thumb_size1 = 'barta-size5';
$thumb_size2 = 'barta-size10';

?>
<div class="box-default <?php echo esc_attr( $template ); ?> <?php echo esc_attr( $data['small_item_style'] ); ?>">
		<?php if ( $data['has_sec_title'] == 'yes' ) { ?>
			<div class="mb-25p">
				<div class="rt-news-box-title-holder <?php echo esc_attr( $data['title_style'] ); ?>">
					<h2 class="el-rt-news-box-title <?php echo esc_attr( $data['title_style'] ); ?>"><?php echo esc_html( $data['title'] ); ?><span class="titleinner"></span></h2>
				</div>
			</div>
		<?php } ?>
		<?php
			/*query process*/
			// category
			$category = $data['cat_single_box'] ; 
			// number
			$number_of_post = $data['number_of_post'];
			$number_of_post_offset = $data['number_of_post_offset'];
			$p_ids = array();
			
			// build up the array
			foreach ( $data['posts_not_in'] as $p_idsn ) {
				$p_ids[] = $p_idsn['post_not_in'];
			}
			// sort
			$post_sorting = $data['post_sorting'];
			// order
			$post_ordering = $data['post_ordering'];
			// Title Limit
			$title_limit = $data['post_title_length'];	
			// Content Limit
			$content_limit = $data['post_excerpt_length'];
					
			$args = array(
				'cat' => $category,
				'order' => $post_ordering,
				'posts_per_page' => $number_of_post,
				'offset' 	 	 => $number_of_post_offset,
				'post__not_in'   => $p_ids
			);
			if ( $post_sorting == 'view' ) {
				$args['orderby']  = 'meta_value_num';
				$args['meta_key'] = 'barta_views';
			} else {
				$args['orderby'] = $post_sorting;
			}
			$query = new WP_Query( $args );
			$temp = BartaTheme_Helper::wp_set_temp_query( $query );
			$i = 1;
			if ( $query->have_posts() ) { 
				while ( $query->have_posts() ) {
				$query->the_post();
				$btn = $data['post_readmore'] ? '<br><a href="'.get_the_permalink().'">Read More</a>' : '';
				$excerpt = wp_trim_words( get_the_excerpt(), $content_limit, $btn );
				$news_title = wp_trim_words( get_the_title(), $title_limit, '' );
				$news_comment_num = number_format_i18n( get_comments_number() );
				if ( !empty( $data['post_date_format'] ) ) {
					if ( $data['post_date_format'] == 'global' ){
						$formatted_post_date = get_the_date(); 
					} else {
						$formatted_post_date = get_the_date( 'M d, Y' );
					}
				}
		?>	
		<?php if ( $i == 1 ) { ?>
			<div class="image-wrap">
				<div class="img-scale-animate mb-30">
				<?php if ( $data['show_post_thumb'] == 'yes' ) { ?>
					<a class="img-overlay-70" href="<?php the_permalink(); ?>">
						<?php
							if ( has_post_thumbnail() ){
								the_post_thumbnail( $thumb_size1, ['class' => 'img-fluid mb-10 width-100'] );
							} else {
								if ( $data['show_no_preview_img'] == 'yes') {
								
									if ( !empty( BartaTheme::$options['no_preview_image']['id'] ) ) {
										echo wp_get_attachment_image( BartaTheme::$options['no_preview_image']['id'], $thumb_size1 );
									} else {
										echo '<img class="wp-post-image" src="' . BartaTheme_Helper::get_img( 'noimage-555x370.jpg' ) . '" alt="'.get_the_title().'">';
									}
								}
							}
						?>
					</a>
					<?php if ( $data['cat_display'] == 'yes' ) { ?> 
					<div class="topic-box-top-lg"><?php echo barta_sel_category_prepare( $category ); ?></div>
					<?php } ?>
				<?php } ?>
				</div>
				<div class="content-info">
					<div class="post-meta-light">
						<ul>
							<?php if ( $data['post_author'] == 'yes') { ?>
								<li><span><i class="fa fa-user" aria-hidden="true"></i></span><?php the_author_posts_link(); ?></li>
							<?php } ?>
							<?php if ( $data['post_date'] == 'yes' ) { ?>
								<li><span><i class="fa fa-clock-o" aria-hidden="true"></i></span><?php echo $formatted_post_date; ?></li>
							<?php } ?>
							<?php if ( $data['post_comment'] == 'yes' ) { ?>
								<li><span><i class="fa fa-comment-o" aria-hidden="true"></i></span><a href="<?php echo get_comments_link( get_the_ID() ); ?>"> <?php echo esc_html( $news_comment_num );?></a></li>
							<?php } ?>
						</ul>
					</div>
					<h2 class="title-medium-light">
						<a href="<?php the_permalink(); ?>"><?php echo esc_html( $news_title ); ?></a>
					</h2>
					<p class="box-content mb-30"><?php echo wp_kses_post( $excerpt ); ?></p>
				</div>
			</div>
		<?php } ?>
		<?php if ( $i == 2 ) { ?>
		<div class="content-bottom item-shadow-gray">
		<?php } ?>
		<?php if ( $i > 1 ) { ?>
			<div class="media mb-30">
				<?php if ( $data['show_post_thumb'] == 'yes' && $data['small_item_img_display'] ) { ?>
				<div class="image-left">
					<a class="img-opacity-hover" href="<?php the_permalink(); ?>">
						<?php
							if ( has_post_thumbnail() ){
								the_post_thumbnail( $thumb_size2, ['class' => 'img-fluid mb-10 width-100'] );
							} else {
								if ( $data['show_no_preview_img'] == 'yes') {
								
									if ( !empty( BartaTheme::$options['no_preview_image']['id'] ) ) {
										echo wp_get_attachment_image( BartaTheme::$options['no_preview_image']['id'], $thumb_size2 );
									} else {
										echo '<img class="wp-post-image" src="' . BartaTheme_Helper::get_img( 'noimage-152x136.jpg' ) . '" alt="'.get_the_title().'">';
									}
								}
							}
						?>
					</a>
				</div>
				<?php } ?>
				<div class="media-body">
					<div class="post-meta-dark">
						<ul>
							<?php if ( $data['post_author'] == 'yes') { ?>
								<li><span><i class="fa fa-user" aria-hidden="true"></i></span><?php the_author_posts_link(); ?></li>
							<?php } ?>
							<?php if ( $data['post_date'] == 'yes' ) { ?>
								<li><span><i class="fa fa-clock-o" aria-hidden="true"></i></span><?php echo $formatted_post_date; ?></li>
							<?php } ?>
							<?php if ( $data['post_comment'] == 'yes' ) { ?>
								<li><span><i class="fa fa-comment-o" aria-hidden="true"></i></span><a href="<?php echo get_comments_link( get_the_ID() ); ?>"> <?php echo esc_html( $news_comment_num );?></a></li>
							<?php } ?>
						</ul>
					</div>
					<h3 class="title-medium-dark">
						<a href="<?php the_permalink(); ?>"><?php echo esc_html( $news_title ); ?></a>
					</h3>
				</div>
			</div>
		<?php } ?>
		<?php if ( $query->post_count == $i ) { ?>
		</div>
		<?php } ?>
			<?php $i++; } ?>		
			<?php  } ?>
		<?php BartaTheme_Helper::wp_reset_temp_query( $temp ); ?>
</div>