;/**
 * Slidebars - A jQuery Framework for Off-Canvas Menus and Sidebars
 * Version: 2.0.2
 * Url: http://www.adchsm.com/slidebars/
 * Author: Adam Charles Smith
 * Author url: http://www.adchsm.com/
 * License: MIT
 * License url: http://www.adchsm.com/slidebars/license/
 *
 * Modified by: Jory Hogeveen
 * Version numbers and info below is related to Off-Canvas Sidebars, not Slidebars.
 *
 * @package Off_Canvas_Sidebars
 * @author  Jory Hogeveen <info@keraweb.nl>
 *
 * @version  0.5.7
 * @since    0.4.0  Add scope for this reference + Add legacy CSS support (no hardware acceleration)
 * @since    0.4.2  Parse slidebar widths/heights to rounded pixels (like jQuery does) to prevent 1px differences
 * @since    0.5.6  Added `initialized` and `reinit` methods.
 * @since    0.5.7  Data attributes.
 * @global   slidebars
 * @preserve
 */
var slidebars;(function($){slidebars=function(){var canvas=$("[data-canvas]"),offCanvas={},self=this,init=false,registered=false,sides=["top","right","bottom","left"],styles=["reveal","push","overlay","shift"],getAnimationProperties=function(id){var elements=$(),amount="0px, 0px",size="0px",duration=parseFloat(offCanvas[id].element.css("transitionDuration"))*1e3;if("reveal"===offCanvas[id].style||"push"===offCanvas[id].style||"shift"===offCanvas[id].style){elements=elements.add(canvas)}if("reveal"===offCanvas[id].style&&("top"===offCanvas[id].side||"bottom"===offCanvas[id].side)){elements=elements.add(offCanvas[id].element)}if("push"===offCanvas[id].style||"overlay"===offCanvas[id].style||"shift"===offCanvas[id].style){elements=elements.add(offCanvas[id].element)}if(offCanvas[id].active||self.legacy){if("top"===offCanvas[id].side||"bottom"===offCanvas[id].side){size=offCanvas[id].element.css("height")}else{size=offCanvas[id].element.css("width")}if(self.legacy){amount=size}else{if("top"===offCanvas[id].side){amount="0px, "+size}else if("right"===offCanvas[id].side){amount="-"+size+", 0px"}else if("bottom"===offCanvas[id].side){amount="0px, -"+size}else if("left"===offCanvas[id].side){amount=size+", 0px"}}}return{elements:elements,amount:amount,duration:duration}},registerSlidebar=function(id,side,style,element){if(isRegisteredSlidebar(id)){throw"Error registering Slidebar, a Slidebar with id '"+id+"' already exists."}offCanvas[id]={id:id,side:side,style:style,element:element,active:false}},isRegisteredSlidebar=function(id){return offCanvas.hasOwnProperty(id)};this.legacy=false;this.initialized=function(){return init};this.reinit=function(callback){if(this.initialized()){this.exit()}this.init(callback)};this.init=function(callback){if(init){throw"Slidebars has already been initialized."}if(!registered){$("[data-off-canvas]").each(function(){var parameters=$(this).data("off-canvas").split(" ",3);if(!parameters||!parameters[0]||-1===sides.indexOf(parameters[1])||-1===styles.indexOf(parameters[2])){throw"Error registering Slidebar, please specify a valid id, side and style'."}registerSlidebar(parameters[0],parameters[1],parameters[2],$(this))});registered=true}init=true;this.css();$(events).trigger("init");if("function"===typeof callback){callback()}};this.exit=function(callback){if(!init){throw"Slidebars hasn't been initialized."}var exit=function(){init=false;$(events).trigger("exit");if("function"===typeof callback){callback()}};if(this.getActiveSlidebar()){this.close(exit)}else{exit()}};this.css=function(callback){if(!init){throw"Slidebars hasn't been initialized."}for(var id in offCanvas){if(offCanvas.hasOwnProperty(id)&&isRegisteredSlidebar(id)){var offset;if("top"===offCanvas[id].side||"bottom"===offCanvas[id].side){offCanvas[id].element.css("height","");offset=offCanvas[id].element.css("height");offCanvas[id].element.css("height",offset)}else{offCanvas[id].element.css("width","");offset=offCanvas[id].element.css("width");offCanvas[id].element.css("width",offset)}var do_offset=false;if("push"===offCanvas[id].style||"overlay"===offCanvas[id].style||"shift"===offCanvas[id].style){do_offset=true}else if("reveal"===offCanvas[id].style&&("top"===offCanvas[id].side||"bottom"===offCanvas[id].side)){do_offset=true}if(do_offset){offCanvas[id].element.css("margin-"+offCanvas[id].side,"-"+offset);if(self.legacy&&"shift"===offCanvas[id].style){var shiftPos;if("top"===offCanvas[id].side||"bottom"===offCanvas[id].side){shiftPos=offCanvas[id].element.height()/1.9}else if("left"===offCanvas[id].side||"right"===offCanvas[id].side){shiftPos=offCanvas[id].element.width()/1.9}if("left"===offCanvas[id].side||"right"===offCanvas[id].side){offCanvas[id].element.css(offCanvas[id].side,shiftPos+"px")}}}}}if(this.getActiveSlidebar()){this.open(this.getActiveSlidebar())}$(events).trigger("css");if("function"===typeof callback){callback()}};this.open=function(id,callback){if(!init){throw"Slidebars hasn't been initialized."}if(!id||!isRegisteredSlidebar(id)){throw"Error opening Slidebar, there is no Slidebar with id '"+id+"'."}var open=function(){offCanvas[id].active=true;offCanvas[id].element.css("display","block");$(events).trigger("opening",[offCanvas[id].id]);var animationProperties=getAnimationProperties(id);var css={"-webkit-transition-duration":animationProperties.duration+"ms","-moz-transition-duration":animationProperties.duration+"ms","-o-transition-duration":animationProperties.duration+"ms","transition-duration":animationProperties.duration+"ms"};if(self.legacy){css[offCanvas[id].side]=animationProperties.amount;var canvasSide;if("right"===offCanvas[id].side||"bottom"===offCanvas[id].side){if("right"===offCanvas[id].side){canvasSide="left"}else if("bottom"===offCanvas[id].side){canvasSide="top"}var canvasCss={"-webkit-transition-duration":animationProperties.duration+"ms","-moz-transition-duration":animationProperties.duration+"ms","-o-transition-duration":animationProperties.duration+"ms","transition-duration":animationProperties.duration+"ms"};canvasCss[canvasSide]="-"+animationProperties.amount;if("overlay"!==offCanvas[id].style){canvas.css(canvasCss)}animationProperties.elements.not(canvas).css(css)}else{animationProperties.elements.css(css)}}else{css.transform="translate("+animationProperties.amount+")";animationProperties.elements.css(css)}setTimeout(function(){$(events).trigger("opened",[offCanvas[id].id]);if("function"===typeof callback){callback()}},animationProperties.duration)};if(this.getActiveSlidebar()&&this.getActiveSlidebar()!==id){this.close(open)}else{open()}};this.close=function(id,callback){if("function"===typeof id){callback=id;id=null}if(!init){throw"Slidebars hasn't been initialized."}if(id&&!isRegisteredSlidebar(id)){throw"Error closing Slidebar, there is no Slidebar with id '"+id+"'."}if(!id){id=this.getActiveSlidebar()}if(id&&offCanvas[id].active){offCanvas[id].active=false;$(events).trigger("closing",[offCanvas[id].id]);var animationProperties=getAnimationProperties(id);if(self.legacy){var css={};var canvasSide;if("right"===offCanvas[id].side||"bottom"===offCanvas[id].side){if("right"===offCanvas[id].side){canvasSide="left"}else if("bottom"===offCanvas[id].side){canvasSide="top"}canvas.css(canvasSide,"");animationProperties.elements.not(canvas).css(offCanvas[id].side,"")}else{animationProperties.elements.css(offCanvas[id].side,"")}if("shift"===offCanvas[id].style){var shiftPos;if("top"===offCanvas[id].side||"bottom"===offCanvas[id].side){shiftPos=offCanvas[id].element.height()/1.9}else if("left"===offCanvas[id].side||"right"===offCanvas[id].side){shiftPos=offCanvas[id].element.width()/1.9}if("left"===offCanvas[id].side||"right"===offCanvas[id].side){offCanvas[id].element.css(offCanvas[id].side,shiftPos+"px")}}}else{animationProperties.elements.css("transform","")}setTimeout(function(){animationProperties.elements.css({"-webkit-transition-duration":"","-moz-transition-duration":"","-o-transition-duration":"","transition-duration":""});offCanvas[id].element.css("display","");$(events).trigger("closed",[offCanvas[id].id]);if("function"===typeof callback){callback()}},animationProperties.duration)}};this.toggle=function(id,callback){if(!init){throw"Slidebars hasn't been initialized."}if(!id||!isRegisteredSlidebar(id)){throw"Error toggling Slidebar, there is no Slidebar with id '"+id+"'."}if(offCanvas[id].active){this.close(id,function(){if("function"===typeof callback){callback()}})}else{this.open(id,function(){if("function"===typeof callback){callback()}})}};this.isActive=function(id){return init};this.isActiveSlidebar=function(id){if(!init){throw"Slidebars hasn't been initialized."}if(!id){throw"You must provide a Slidebar id."}if(!isRegisteredSlidebar(id)){throw"Error retrieving Slidebar, there is no Slidebar with id '"+id+"'."}return offCanvas[id].active};this.getActiveSlidebar=function(){if(!init){throw"Slidebars hasn't been initialized."}var active=false;for(var id in offCanvas){if(isRegisteredSlidebar(id)){if(offCanvas[id].active){active=offCanvas[id].id;break}}}return active};this.getSlidebars=function(){if(!init){throw"Slidebars hasn't been initialized."}var slidebarsArray=[];for(var id in offCanvas){if(isRegisteredSlidebar(id)){slidebarsArray.push(offCanvas[id].id)}}return slidebarsArray};this.getSlidebar=function(id){if(!init){throw"Slidebars hasn't been initialized."}if(!id){throw"You must pass a Slidebar id."}if(!id||!isRegisteredSlidebar(id)){throw"Error retrieving Slidebar, there is no Slidebar with id '"+id+"'."}return offCanvas[id]};this.events={};var events=this.events;$(window).on("resize",this.css.bind(this))}})(jQuery);
